/*
 * Decompiled with CFR 0.152.
 */
package commons.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;

public class ProcessUtil {
    private static byte[] readAndClose(InputStream is) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int n = -1;
            while ((n = is.read()) != -1) {
                bos.write(n);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String exec(String ... cmd) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd);
            proc.getOutputStream().close();
            InputStream is = proc.getInputStream();
            InputStream eis = proc.getErrorStream();
            CountDownLatch endFlag = new CountDownLatch(1);
            ErrorStreamReader esr = new ErrorStreamReader(eis, endFlag);
            esr.start();
            String isMsg = new String(ProcessUtil.readAndClose(is));
            endFlag.await();
            String string = String.valueOf(isMsg) + esr.getMsg();
            return string;
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            return string;
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    public static void main(String[] args) {
        String msg = ProcessUtil.exec("cmd", "/C", "C:/Program Files/Elaborate Bytes/VirtualCloneDrive/VCDMount.exe", "/d=0", "C:/hufeng/hufeng/ext/iso/tm.iso");
        System.out.println(msg);
    }

    private static class ErrorStreamReader
    extends Thread {
        private InputStream is;
        private CountDownLatch endFlag;
        private String msg;

        ErrorStreamReader(InputStream is, CountDownLatch endFlag) {
            this.is = is;
            this.endFlag = endFlag;
            this.msg = "";
        }

        @Override
        public void run() {
            this.msg = new String(ProcessUtil.readAndClose(this.is));
            this.endFlag.countDown();
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

