/*
 * Decompiled with CFR 0.152.
 */
package commons.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.xwork.StringUtils;

public class HttpUtil {
    public static final int DEFAULT_READ_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 1000;
    public static final String DEFAULT_RETURN_ENCODING = "GBK";

    public static String get(String urlStr) throws Exception {
        return HttpUtil.get(urlStr, null);
    }

    public static String get(String urlStr, String defaultReturnEncoding) throws Exception {
        return HttpUtil.get(urlStr, defaultReturnEncoding, 10000, 1000);
    }

    public static String get(String urlStr, String defaultReturnEncoding, int readTimeoutMS, int connectTimeoutMS) throws Exception {
        HttpRequest hr = new HttpRequest();
        hr.setMethod(HttpMethod.GET);
        hr.setUrl(urlStr);
        hr.setReadTimeoutMS(readTimeoutMS);
        hr.setConnectTimeoutMS(connectTimeoutMS);
        hr.setResponseEncoding(defaultReturnEncoding);
        return HttpUtil.fire(hr).getResponseText();
    }

    public static String post(String urlStr, Map<String, String> paramMap, String encoding) throws Exception {
        return HttpUtil.post(urlStr, paramMap, encoding, 10000, 1000);
    }

    public static String post(String urlStr, Map<String, String> paramMap, String encoding, int readTimeoutMS, int connectTimeoutMS) throws Exception {
        HttpRequest hr = new HttpRequest();
        hr.setMethod(HttpMethod.POST);
        hr.setUrl(urlStr);
        hr.setParamMap(paramMap);
        hr.setParamEncoding(encoding);
        hr.setReadTimeoutMS(readTimeoutMS);
        hr.setConnectTimeoutMS(connectTimeoutMS);
        hr.setResponseEncoding(encoding);
        return HttpUtil.fire(hr).getResponseText();
    }

    public static String toQueryString(Map<String, String> paramMap, String encoding) throws UnsupportedEncodingException {
        if (paramMap == null || paramMap.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : paramMap.keySet()) {
            String val = paramMap.get(key);
            if (sb.length() > 0) {
                sb.append("&");
            }
            if (key != null) {
                sb.append(URLEncoder.encode(key, encoding));
            }
            sb.append("=");
            if (val == null) continue;
            sb.append(URLEncoder.encode(val, encoding));
        }
        return sb.toString();
    }

    public static HttpResponse fire(HttpRequest req) throws Exception {
        HttpURLConnection con = null;
        OutputStream output = null;
        InputStream input = null;
        try {
            int nx;
            int respCode;
            String paramStr;
            boolean isPost = req.getMethod() == HttpMethod.POST;
            String urlStr = req.getUrl();
            String string = paramStr = isPost && req.getPostData() != null ? req.getPostData() : HttpUtil.toQueryString(req.getParamMap(), req.getParamEncoding());
            if (!isPost && paramStr != null && paramStr.length() > 0) {
                int nx2 = urlStr.indexOf("?");
                if (nx2 == -1) {
                    urlStr = String.valueOf(urlStr) + "?" + paramStr;
                } else {
                    String urlEnd = urlStr.substring(nx2 + 1);
                    urlStr = String.valueOf(urlStr.substring(0, nx2 + 1)) + paramStr + (urlEnd.length() > 0 ? "&" : "") + urlEnd;
                }
            }
            URL url = new URL(urlStr);
            con = (HttpURLConnection)url.openConnection();
            con.setReadTimeout(req.getReadTimeoutMS());
            con.setConnectTimeout(req.getConnectTimeoutMS());
            con.setRequestMethod(req.getMethod().name());
            con.setDoInput(true);
            con.setUseCaches(false);
            if (isPost) {
                con.setRequestProperty("Content-Length", String.valueOf(paramStr.length()));
                con.setDoOutput(true);
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            if (req.getHeaderMap() != null) {
                for (String key : req.getHeaderMap().keySet()) {
                    con.setRequestProperty(key, req.getHeaderMap().get(key));
                }
            }
            con.connect();
            if (isPost && paramStr.length() > 0) {
                output = con.getOutputStream();
                output.write(paramStr.getBytes(req.paramEncoding));
                output.flush();
            }
            if ((respCode = con.getResponseCode()) != 200) {
                String newUrl;
                if ((respCode == 301 || respCode == 302) && StringUtils.isNotBlank((String)(newUrl = con.getHeaderField("Location")))) {
                    req.setUrl(newUrl);
                    HttpResponse httpResponse = HttpUtil.fire(req);
                    return httpResponse;
                }
                throw new RuntimeException("Http response code=" + respCode);
            }
            input = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] bs = new byte[10240];
            int n = -1;
            while ((n = input.read(bs)) != -1) {
                bos.write(bs, 0, n);
            }
            String retEncoding = req.getResponseEncoding();
            String contType = con.getContentType();
            if (contType != null && (nx = contType.toLowerCase().indexOf("charset=")) != -1) {
                retEncoding = contType.substring(nx + 8);
            }
            HttpResponse httpResponse = new HttpResponse(con.getHeaderFields(), bos.toByteArray(), retEncoding);
            return httpResponse;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String normalURL(String base, String curr) {
        String domain;
        if (curr.toLowerCase().startsWith("http")) {
            return curr;
        }
        int level = 0;
        if (curr.startsWith("./")) {
            curr = curr.substring(2);
        } else if (curr.startsWith("/")) {
            level = -1;
        } else if (curr.startsWith("../")) {
            while (curr.startsWith("../")) {
                curr = curr.substring(3);
                ++level;
            }
        }
        String path = "";
        int n = base.indexOf("/", 9);
        if (n == -1) {
            domain = base;
        } else {
            domain = base.substring(0, n);
            path = base.substring(n);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            } else {
                n = path.lastIndexOf("/");
                path = path.substring(0, n);
            }
        }
        if (level == -1) {
            return String.valueOf(domain) + curr;
        }
        if (level > 0) {
            int i = 0;
            while (i < level) {
                n = path.lastIndexOf("/");
                if (n == -1) break;
                path = path.substring(0, n);
                ++i;
            }
        }
        return String.valueOf(domain) + path + "/" + curr;
    }

    public static void main(String[] args) throws Exception {
        try {
            String txt = HttpUtil.get("http://zz.zhue.com.cn/plus/view.php?aid=5725");
            System.out.println(txt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static enum HttpMethod {
        POST,
        GET;

    }

    public static class HttpRequest {
        private HttpMethod method = HttpMethod.GET;
        private String url;
        private Map<String, String> paramMap;
        private String paramEncoding = "GBK";
        private String postData;
        private String responseEncoding = "GBK";
        private int readTimeoutMS = 30000;
        private int connectTimeoutMS = 1000;
        private Map<String, String> headerMap = new HashMap<String, String>();

        public HttpRequest() {
            this.headerMap.put("Connection", "Close");
            this.headerMap.put("User-Agent", "Mozilla/5.0 (Windows NT 5.1; rv:11.0) Gecko/20100101 Firefox/11.0");
        }

        public void setParamMap(Map<String, String> paramMap) {
            this.paramMap = paramMap;
        }

        public Map<String, String> getParamMap() {
            return this.paramMap;
        }

        public String getParamEncoding() {
            return this.paramEncoding;
        }

        public void setParamEncoding(String paramEncoding) {
            this.paramEncoding = paramEncoding;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getResponseEncoding() {
            return this.responseEncoding;
        }

        public void setResponseEncoding(String responseEncoding) {
            this.responseEncoding = responseEncoding;
        }

        public int getReadTimeoutMS() {
            return this.readTimeoutMS;
        }

        public void setReadTimeoutMS(int readTimeoutMS) {
            this.readTimeoutMS = readTimeoutMS;
        }

        public int getConnectTimeoutMS() {
            return this.connectTimeoutMS;
        }

        public void setConnectTimeoutMS(int connectTimeoutMS) {
            this.connectTimeoutMS = connectTimeoutMS;
        }

        public Map<String, String> getHeaderMap() {
            return this.headerMap;
        }

        public void setHeaderMap(Map<String, String> headerMap) {
            this.headerMap = headerMap;
        }

        public String getPostData() {
            return this.postData;
        }

        public void setPostData(String postData) {
            this.postData = postData;
        }
    }

    public static class HttpResponse {
        private Map<String, List<String>> headerMap;
        private byte[] responseData;
        private String encoding;

        public HttpResponse(Map<String, List<String>> headerMap, byte[] responseData, String encoding) {
            this.headerMap = headerMap;
            this.responseData = responseData;
            this.encoding = encoding;
        }

        public Map<String, List<String>> getHeaderMap() {
            return this.headerMap;
        }

        public byte[] getResponseData() {
            return this.responseData;
        }

        public String getResponseText() {
            if (this.responseData == null) {
                return "";
            }
            try {
                return new String(this.responseData, this.encoding == null ? HttpUtil.DEFAULT_RETURN_ENCODING : this.encoding);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

