/*
 * Decompiled with CFR 0.152.
 */
package commons.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {
    public static String current(String pattern) {
        return new SimpleDateFormat(pattern).format(new Date());
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        if (pattern == null) {
            return date.toString();
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String parseFormat(String dateStr, String parsePattern, String formatPattern) {
        if (dateStr == null) {
            return "";
        }
        return DateUtil.format(DateUtil.parse(dateStr, parsePattern), formatPattern);
    }

    public static Date formatParse(Date date, String formatPattern, String parsePattern) {
        if (date == null) {
            return null;
        }
        return DateUtil.parse(DateUtil.format(date, formatPattern), parsePattern);
    }

    public static Date parse(String date, String pattern) {
        if (date == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date toDate(Date date) {
        return DateUtil.formatParse(date, "yyyyMMdd", "yyyyMMdd");
    }

    public static Date toMaxTime(Date date) {
        return DateUtil.parse(String.valueOf(DateUtil.format(date, "yyyyMMdd")) + "235959", "yyyyMMddHHmmss");
    }

    public static int compareMonths(Date begin, Date end) {
        if (begin == null || end == null) {
            throw new IllegalArgumentException("argument is null, begin=" + DateUtil.format(begin, "yyyyMMdd") + ", end=" + DateUtil.format(end, "yyyyMMdd"));
        }
        if ((begin = DateUtil.formatParse(begin, "yyyyMM", "yyyyMM")).after(end = DateUtil.formatParse(end, "yyyyMM", "yyyyMM"))) {
            throw new IllegalArgumentException("argument begin=" + DateUtil.format(begin, "yyyyMM") + " is after end=" + DateUtil.format(end, "yyyyMM"));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(end);
        int endYear = cal.get(1);
        int endMonth = cal.get(2);
        cal.setTime(begin);
        int yy = cal.get(1);
        int mm = cal.get(2);
        int n = 0;
        while (yy != endYear || mm != endMonth) {
            ++n;
            cal.add(2, 1);
            yy = cal.get(1);
            mm = cal.get(2);
        }
        return n;
    }

    public static int compareDays(Date begin, Date end) {
        return (int)((DateUtil.toDate(end).getTime() - DateUtil.toDate(begin).getTime()) / 86400000L);
    }

    public static long compareMinutes(Date begin, Date end) {
        return (DateUtil.formatParse(end, "yyyyMMddHHmm", "yyyyMMddHHmm").getTime() - DateUtil.formatParse(begin, "yyyyMMddHHmm", "yyyyMMddHHmm").getTime()) / 60000L;
    }

    public static Date addDays(Date date, int days) {
        if (days == 0) {
            return date;
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, days);
        return ca.getTime();
    }

    public static List<Date> splitDays(Date begin, Date end) {
        int n = DateUtil.compareDays(begin, end);
        if (n < 0) {
            return null;
        }
        ArrayList<Date> days = new ArrayList<Date>();
        Date p = DateUtil.toDate(begin);
        days.add(p);
        int i = 0;
        while (i < n) {
            p = DateUtil.addDays(p, 1);
            days.add(p);
            ++i;
        }
        return days;
    }

    public static int getMonthDays(Date date) {
        Date lastDay = DateUtil.getMonthLastDay(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastDay);
        return cal.get(5);
    }

    public static Date getMonthFirstDay(Date d) {
        return DateUtil.parse(String.valueOf(DateUtil.format(d, "yyyyMM")) + "01", "yyyyMMdd");
    }

    public static Date getMonthLastDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getMonthFirstDay(d));
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static List<Date> splitMonths(Date begin, Date end) {
        if ((begin = DateUtil.getMonthFirstDay(begin)).after(end = DateUtil.getMonthFirstDay(end))) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(end);
        int endYear = c1.get(1);
        int endMonth = c1.get(2);
        ArrayList<Date> months = new ArrayList<Date>();
        c1.setTime(begin);
        int y = c1.get(1);
        int m = c1.get(2);
        while (y != endYear || m != endMonth) {
            months.add(c1.getTime());
            c1.add(2, 1);
            y = c1.get(1);
            m = c1.get(2);
        }
        months.add(end);
        return months;
    }

    public static int getYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(1);
    }

    public static void main(String[] args) {
        Date d = DateUtil.parse("201106", "yyyyMM");
        Date d2 = DateUtil.parse("201205", "yyyyMM");
        List<Date> dds = DateUtil.splitMonths(d, d2);
        for (Date ds : dds) {
            System.out.println(DateUtil.format(ds, "yyyy-MM-dd HH:mm:ss"));
        }
        System.out.println(DateUtil.getYear(d));
    }
}

