/*
 * Decompiled with CFR 0.152.
 */
package commons.util;

import javax.servlet.http.HttpServletResponse;

public class DataExportUtil {
    public static void setHead(HttpServletResponse response, String fileName, OpenType openType, ContentType contentType) {
        try {
            if (fileName == null) {
                fileName = String.valueOf(System.currentTimeMillis());
            }
            if (!fileName.endsWith(contentType.extention)) {
                fileName = String.valueOf(fileName) + "." + contentType.extention;
            }
            response.setContentType(contentType.value);
            String headerDisp = String.valueOf(openType.value) + ";filename=" + fileName;
            headerDisp = new String(headerDisp.getBytes("GBK"), "iso8859-1");
            response.setHeader("content-disposition", headerDisp);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static enum ContentType {
        EXCEL("application/vnd.ms-excel", "xls"),
        Word("application/vnd.ms-word", "doc"),
        Txt("text/plain", "txt");

        public final String value;
        public final String extention;

        private ContentType(String v, String ext) {
            this.value = v;
            this.extention = ext;
        }
    }

    public static enum OpenType {
        INLINE("inline"),
        ATTACHMENT("attachment");

        public final String value;

        private OpenType(String v) {
            this.value = v;
        }
    }
}

