/*
 * Decompiled with CFR 0.152.
 */
package commons.tags;

import commons.db.Pager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(PagerFilter.class);
    private static final ThreadLocal<Pager> pageVar = new ThreadLocal();

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.parsePageVariable((HttpServletRequest)req);
        try {
            chain.doFilter(req, resp);
        }
        finally {
            pageVar.set(null);
        }
    }

    protected void parsePageVariable(HttpServletRequest req) {
        Pager pv = new Pager();
        pageVar.set(pv);
        String cp = req.getParameter("_curr_page_");
        if (StringUtils.isBlank((String)cp)) {
            pv.setCurrentPage(1);
        } else {
            try {
                pv.setCurrentPage(Integer.parseInt(cp));
                if (pv.getCurrentPage() < 1) {
                    pv.setCurrentPage(1);
                }
            }
            catch (Exception ex) {
                pv.setCurrentPage(1);
                log.error("", (Throwable)ex);
            }
        }
        try {
            String perSize = req.getParameter("_per_page_size_");
            if (StringUtils.isNotBlank((String)perSize)) {
                pv.setRecordPerPage(Integer.parseInt(perSize));
                if (pv.getRecordPerPage() < 1) {
                    pv.setRecordPerPage(1);
                }
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void destroy() {
    }

    public static Pager getPager() {
        return pageVar.get();
    }
}

