/*
 * Decompiled with CFR 0.152.
 */
package commons.tags;

import commons.hibernate.PageQuery;
import commons.spring.ApplicationContextUtil;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HqlTag
extends TagSupport {
    private static final long serialVersionUID = -7405638005158793628L;
    private static Logger log = LoggerFactory.getLogger(PageQuery.class);
    private static HashMap<String, Object> cacheData = new HashMap();
    private String hql = null;
    private String var = null;
    private String max = null;
    private String cache = "false";

    public static void clearCache() {
        cacheData.clear();
        log.info("Clear HqlHelper cache!");
    }

    public int doStartTag() throws JspException {
        try {
            log.debug("[" + this.hql + "]");
            int maxn = this.max != null ? Integer.parseInt(this.max) : -1;
            boolean needCache = "true".equals(this.cache);
            Object data = null;
            if (needCache) {
                String key = String.valueOf(maxn) + "__" + this.hql;
                data = cacheData.get(key);
                if (data == null) {
                    data = this.query(maxn);
                    cacheData.put(key, data);
                } else {
                    log.debug("Get " + maxn + " results from HqlHelper cache for [" + this.hql + "]");
                }
            } else {
                data = this.query(maxn);
            }
            if (this.var != null) {
                this.pageContext.getRequest().setAttribute(this.var, data);
            } else {
                this.pageContext.getOut().write("" + data);
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private Object query(int maxn) {
        Session sess = ApplicationContextUtil.getCurrentSession();
        Query q = sess.createQuery(this.hql);
        if (maxn != -1) {
            q.setMaxResults(maxn);
        }
        return maxn == 1 ? q.uniqueResult() : q.list();
    }

    public String getHql() {
        return this.hql;
    }

    public void setHql(String hql) {
        this.hql = hql;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }
}

