/*
 * Decompiled with CFR 0.152.
 */
package commons.struts2;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private final Logger log = LoggerFactory.getLogger(Message.class);
    private final String message;
    private final boolean isSuccess;
    private final Throwable exception;
    private Set<String> errorList;

    public Message(String message, boolean isSuccess) {
        this(message, isSuccess, null);
    }

    public Message(String message, boolean isSuccess, Throwable exception) {
        this.message = message;
        this.isSuccess = isSuccess;
        this.exception = exception;
        if (this.exception != null) {
            this.log.error(message, exception);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Set<String> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(Set<String> errorList) {
        this.errorList = errorList;
    }
}

