/*
 * Decompiled with CFR 0.152.
 */
package commons.struts2;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.xwork.StringUtils;
import org.apache.struts2.util.StrutsTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeConverter
extends StrutsTypeConverter {
    private static Logger log = LoggerFactory.getLogger(DateTimeConverter.class);
    private static final String[] FORMAT_ARRAY = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM", "HH:mm", "yyyy"};

    public Object convertFromString(Map context, String[] values, Class toClass) {
        if (values == null || values.length < 1 || StringUtils.isBlank((String)values[0])) {
            return null;
        }
        String dstr = values[0].trim();
        String[] stringArray = FORMAT_ARRAY;
        int n = FORMAT_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (f.length() == dstr.length()) {
                try {
                    Date res = new SimpleDateFormat(f).parse(dstr);
                    if (log.isDebugEnabled()) {
                        log.debug("Parse date string [" + dstr + "] with [" + f + "] success!");
                    }
                    return res;
                }
                catch (Exception ex) {
                    log.error("Can not parse date string [" + dstr + "] with [" + f + "]", (Throwable)ex);
                }
            }
            ++n2;
        }
        return null;
    }

    public String convertToString(Map context, Object o) {
        try {
            return new SimpleDateFormat(FORMAT_ARRAY[0]).format((Date)o);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return null;
        }
    }
}

