/*
 * Decompiled with CFR 0.152.
 */
package commons.struts2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import commons.struts2.Message;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.xwork.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAction
extends ActionSupport {
    private static final long serialVersionUID = 1L;
    public static final String OPER_ADD = "add";
    public static final String OPER_EDIT = "edit";
    public static final String RESULT_FORBIDDEN = "forbidden";
    public static final String RESULT_PLAINTEXT = "plaintext";
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Object service = null;
    protected Message message = null;
    protected String oper = null;
    protected String plaintext;
    protected String orderBy = null;

    public String getOper() {
        return this.oper;
    }

    public void setOper(String oper) {
        this.oper = oper;
    }

    public String messageJsonResult() {
        this.plaintext = "{\"success\":" + this.message.isSuccess() + ",\"message\":\"" + this.message.getMessage() + "\"}";
        return RESULT_PLAINTEXT;
    }

    public String operate() throws Exception {
        Method mh = null;
        try {
            mh = ((Object)((Object)this)).getClass().getMethod(this.oper, new Class[0]);
            if (!mh.getReturnType().equals(String.class)) {
                this.log.warn("Method '" + this.oper + "' result type is not String.");
                return RESULT_FORBIDDEN;
            }
        }
        catch (Exception ex) {
            this.log.debug("operate find method '" + this.oper + "' occurred exception.", (Throwable)ex);
            return RESULT_FORBIDDEN;
        }
        Object res = mh.invoke((Object)this, new Object[0]);
        return (String)res;
    }

    public <T> void setService(T obj) {
        this.service = obj;
    }

    public <T> T getService() {
        return (T)this.service;
    }

    public void setMessage(Message msg) {
        this.message = msg;
    }

    public void setMessage(String msg, boolean isSuccess) {
        this.message = new Message(msg, isSuccess);
    }

    public Message getMessage() {
        return this.message;
    }

    public List<String> getParams(String key) {
        Map mp = ActionContext.getContext().getParameters();
        String[] ss = (String[])mp.get(key);
        ArrayList<String> res = new ArrayList<String>();
        if (ss != null) {
            int i = 0;
            while (i < ss.length) {
                String s = ss[i].trim();
                if (!"".equals(s)) {
                    res.add(s);
                }
                ++i;
            }
        }
        return res.size() > 0 ? res : null;
    }

    public String getParam(String key) {
        List<String> ss = this.getParams(key);
        return ss != null ? ss.get(0) : null;
    }

    public String getPlaintext() {
        return this.plaintext;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getOrderBy(String defaultValue) {
        if (StringUtils.isBlank((String)this.orderBy)) {
            this.orderBy = defaultValue;
        }
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }
}

