/*
 * Decompiled with CFR 0.152.
 */
package commons.spring;

import java.util.Comparator;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;

public class WebappLocationConvertor {
    public static final String WEBAPP_PREFIX = "webapp:";
    private static volatile TreeMap<String, String> locationMap = new TreeMap(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o2.compareTo(o1);
        }
    });

    public static void addLocationMap(String src, String dest) {
        locationMap.put(src, dest);
    }

    public static String[] convertLocations(String[] locations, ServletContext scontext) {
        if (locations == null) {
            return locations;
        }
        String[] res = new String[locations.length];
        int i = 0;
        while (i < locations.length) {
            String oldP = locations[i];
            res[i] = WebappLocationConvertor.convertLocation(oldP, scontext);
            ++i;
        }
        return res;
    }

    public static String convertLocation(String location, ServletContext scontext) {
        if (scontext == null) {
            throw new IllegalArgumentException("ServletContext is null, Can not convert location for [" + location + "]");
        }
        if (location == null) {
            return location;
        }
        if ((location = WebappLocationConvertor.convertLocationMap(location, scontext)).startsWith(WEBAPP_PREFIX)) {
            String newP = String.valueOf(scontext.getRealPath("/")) + "/" + location.substring(WEBAPP_PREFIX.length());
            newP = "file:" + FilenameUtils.normalize((String)newP);
            newP = newP.replaceAll("\\\\", "/");
            scontext.log("###### Spring location convert ###### [" + location + "] to [" + newP + "]");
            return newP;
        }
        return location;
    }

    private static String convertLocationMap(String src, ServletContext scontext) {
        for (String prefix : locationMap.keySet()) {
            if (src.length() < prefix.length() || !prefix.equals(src.substring(0, prefix.length()))) continue;
            String res = String.valueOf(locationMap.get(prefix)) + src.substring(prefix.length());
            scontext.log("###### location map convert ###### [" + src + "] to [" + res + "]");
            return res;
        }
        return src;
    }
}

