/*
 * Decompiled with CFR 0.152.
 */
package commons.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringUtil {
    private static BeanFactory beanFactory;
    private static RuntimeException exception;
    private static Logger log;

    static {
        log = LoggerFactory.getLogger(SpringUtil.class);
    }

    public static boolean initSpring(String ... classPathConfigFiles) {
        try {
            beanFactory = new ClassPathXmlApplicationContext(classPathConfigFiles);
            log.info("Initialize spring BeanFactory successful!");
            return true;
        }
        catch (Throwable ex) {
            exception = new RuntimeException(ex);
            log.error("Initialize spring BeanFactory occurred exception", ex);
            return false;
        }
    }

    public static <T> T getBean(String id) {
        if (exception != null) {
            throw exception;
        }
        try {
            return (T)beanFactory.getBean(id);
        }
        catch (Exception ex) {
            log.error("Get spring bean occurred exception : " + ex.getMessage());
            return null;
        }
    }
}

