/*
 * Decompiled with CFR 0.152.
 */
package commons.module;

import commons.module.ClassLoaderUtil;
import commons.module.ModuleClassLoaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static Logger log = LoggerFactory.getLogger(ModuleManager.class);
    private static final SimpleDateFormat SUB_DIR = new SimpleDateFormat("yy" + File.separator + "MMdd" + File.separator + "HHmmss");
    public static final String SUB_DIR_CLASSES = "classes";
    public static final String SUB_DIR_LIB = "lib";
    public static final String SERVICES_CONFIG_FILE_NAME = "services.conf";
    private String moduleDir;
    private RuntimeException initException;
    private ConcurrentHashMap<String, Object> serviceMap;

    public synchronized void init() {
        File workDir = null;
        try {
            workDir = this.copyToWorkDir();
            ClassLoader cls = ModuleClassLoaderFactory.createClassLoader(workDir, SUB_DIR_LIB, SUB_DIR_CLASSES);
            ConcurrentHashMap<String, Object> sMap = this.initServices(new File(this.moduleDir), cls);
            this.serviceMap = sMap;
            log.info("Initialize module ClassLoader success!");
        }
        catch (Exception ex) {
            this.deleteWorkDir(workDir);
            this.initException = new RuntimeException(ex);
            throw this.initException;
        }
    }

    private ConcurrentHashMap<String, Object> initServices(File baseDir, ClassLoader cls) throws Exception {
        File sconf = new File(baseDir, SERVICES_CONFIG_FILE_NAME);
        FileInputStream is = new FileInputStream(sconf);
        try {
            Properties prop = new Properties();
            prop.load(is);
            ClassLoader theCls = ModuleManager.class.getClassLoader();
            ConcurrentHashMap<String, Object> sMap = new ConcurrentHashMap<String, Object>(prop.size());
            for (Object key : prop.keySet()) {
                String interfaceStr = key.toString();
                String implClassStr = prop.getProperty(interfaceStr);
                Object serviceObj = ClassLoaderUtil.newInstance(cls, implClassStr, theCls.loadClass(interfaceStr));
                sMap.put(interfaceStr, serviceObj);
                log.info("Initialize service '" + implClassStr + "' success!");
            }
            ConcurrentHashMap<String, Object> concurrentHashMap = sMap;
            return concurrentHashMap;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public <T> T getService(Class<? extends T> t) {
        return (T)this.getServiceMap().get(t.getName());
    }

    public ConcurrentHashMap<String, Object> getServiceMap() {
        if (this.serviceMap != null) {
            return this.serviceMap;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        throw new NullPointerException("The ModuleManager was not initialized, please call method init() before.");
    }

    private void deleteWorkDir(File dir) {
        try {
            if (dir != null && dir.exists()) {
                FileUtils.deleteDirectory((File)dir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File copyToWorkDir() throws IOException {
        File moduleDirFile = new File(this.moduleDir);
        if (!moduleDirFile.exists() || !moduleDirFile.isDirectory()) {
            throw new IllegalArgumentException("Module directory '" + this.moduleDir + "' is not exists.");
        }
        File libDirFile = new File(this.moduleDir);
        String dirStr = String.valueOf(libDirFile.getParent()) + File.separator + "." + libDirFile.getName() + File.separator + SUB_DIR.format(new Date());
        File dir = new File(dirStr);
        dir.mkdirs();
        FileUtils.copyDirectory((File)libDirFile, (File)dir);
        return dir;
    }

    public String getModuleDir() {
        return this.moduleDir;
    }

    public void setModuleDir(String moduleDir) {
        this.moduleDir = moduleDir;
    }
}

