/*
 * Decompiled with CFR 0.152.
 */
package commons.module;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public class ModuleClassLoaderFactory {
    public static ClassLoader createClassLoader(File workDir, String libDir, String classesDir) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        List<File> jarFiles = ModuleClassLoaderFactory.findAllJarFiles(new File(workDir, libDir));
        for (File jf : jarFiles) {
            urls.add(new URL("file", null, jf.getAbsolutePath()));
        }
        File classesDirFile = new File(workDir, classesDir);
        if (classesDirFile.exists() && classesDirFile.isDirectory() && classesDirFile.listFiles().length > 0) {
            urls.add(new URL("file", null, String.valueOf(classesDirFile.getPath()) + "/"));
        }
        if (urls.size() < 1) {
            throw new IllegalArgumentException("Module directory is empty.");
        }
        return new URLClassLoader(urls.toArray(new URL[0]), null);
    }

    private static List<File> findAllJarFiles(File parent) {
        ArrayList<File> res = new ArrayList<File>();
        if (parent.exists() && parent.isDirectory()) {
            File[] fileArray = parent.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File df = fileArray[n2];
                if (df.isFile()) {
                    if (df.getName().toLowerCase().endsWith(".jar") && ModuleClassLoaderFactory.isJarFile(df)) {
                        res.add(df);
                    }
                } else {
                    res.addAll(ModuleClassLoaderFactory.findAllJarFiles(df));
                }
                ++n2;
            }
        }
        return res;
    }

    private static boolean isJarFile(File f) {
        JarFile jf = null;
        try {
            jf = new JarFile(f);
            jf.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

