/*
 * Decompiled with CFR 0.152.
 */
package commons.module;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ClassLoaderUtil {
    public static Object newInstance(ClassLoader moduleClassLoader, String modulImplClazz, Class<?> interfaze) throws Exception {
        ClassLoader oldCLS = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(moduleClassLoader);
            Object moduleObj = moduleClassLoader.loadClass(modulImplClazz).newInstance();
            Object object = Proxy.newProxyInstance(ClassLoaderUtil.class.getClassLoader(), new Class[]{interfaze}, (InvocationHandler)new ModuleInvocationHandler(moduleClassLoader, moduleObj));
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCLS);
        }
    }

    private static class ModuleInvocationHandler
    implements InvocationHandler {
        private ClassLoader moduleClassLoader;
        private Object moduleObject;

        public ModuleInvocationHandler(ClassLoader moduleClassLoader, Object moduleObject) {
            this.moduleClassLoader = moduleClassLoader;
            this.moduleObject = moduleObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader oldCLS = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
                Method moduleMH = this.moduleObject.getClass().getMethod(method.getName(), method.getParameterTypes());
                Object object = moduleMH.invoke(this.moduleObject, args);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCLS);
            }
        }
    }
}

