/*
 * Decompiled with CFR 0.152.
 */
package commons.js;

import java.io.InputStream;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSMathFunction {
    private static Logger log = LoggerFactory.getLogger(JSMathFunction.class);
    private static String MATH_JS_STR = null;

    static {
        try {
            InputStream is = JSMathFunction.class.getClassLoader().getResourceAsStream("commons/js/common.js");
            MATH_JS_STR = IOUtils.toString((InputStream)is, (String)"GBK");
            log.info("Load math functon string successfulq! \n\n" + MATH_JS_STR);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object eval(String scriptStr) throws ScriptException, NoSuchMethodException {
        return JSMathFunction.eval(null, scriptStr);
    }

    public static Object eval(Map<String, VarValue> initVars, String scriptStr) throws ScriptException, NoSuchMethodException {
        ScriptEngine engine = JSMathFunction.createScriptEngine();
        if (initVars != null) {
            for (String key : initVars.keySet()) {
                engine.put(key, initVars.get(key).getValue());
            }
        }
        return engine.eval(scriptStr);
    }

    private static ScriptEngine createScriptEngine() throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("javascript");
        engine.eval(MATH_JS_STR);
        return engine;
    }

    public static void main(String[] args) throws Exception {
        Object r1 = JSMathFunction.eval("(1.0).sub(0.9);");
        Object r2 = JSMathFunction.eval("1.0-0.9;");
        System.out.println(r1);
        System.out.println(r2);
    }

    public static class VarValue {
        private final Object value;
        private final String descr;
        private final String script;
        private boolean isInner = false;

        public VarValue(Object value, String descr) {
            this.value = value;
            this.descr = descr;
            this.script = null;
        }

        public VarValue(Object value, String descr, String script) {
            this.value = value;
            this.descr = descr;
            this.script = script;
        }

        public Object getValue() {
            return this.value;
        }

        public String getDescr() {
            return this.descr;
        }

        public String getScript() {
            return this.script;
        }

        public boolean isInner() {
            return this.isInner;
        }

        public void setInner(boolean isInner) {
            this.isInner = isInner;
        }
    }
}

