/*
 * Decompiled with CFR 0.152.
 */
package commons.hibernate;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.digest.DigestUtils;

public class UniqueIdGenerator {
    private static AtomicLong index = new AtomicLong(0L);
    private static String PREFIX = String.valueOf(UniqueIdGenerator.getUniquePrefix()) + "_" + System.currentTimeMillis() + "_";

    public static String generate() {
        String id = String.valueOf(PREFIX) + index.incrementAndGet();
        return DigestUtils.md5Hex((String)id);
    }

    private static String getUniquePrefix() {
        String res = "";
        try {
            InetAddress ia = InetAddress.getLocalHost();
            res = String.valueOf(ia.getHostName()) + "_" + ia.getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(res) + "_" + new Object().toString();
    }

    public static void main(String[] args) throws UnknownHostException {
        int i = 0;
        while (i < 10) {
            System.out.println(UniqueIdGenerator.generate());
            ++i;
        }
    }
}

