/*
 * Decompiled with CFR 0.152.
 */
package commons.hibernate;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;

public class TablePrimaryKeyManager {
    private static volatile ConcurrentHashMap<String, TableKey> tableKeyMap = new ConcurrentHashMap();
    public static final int MIN_ID = 10000;
    static final String TABLE_NAME = "hb_pk_conf";
    static final String FIELD_TABLE_NAME = "table_name";
    static final String FIELD_NEXT_VAL = "next_val";
    static final String TABLE_SQL = "create table hb_pk_conf(table_name varchar(100) not null,next_val varchar(30) not null,primary key(table_name))";
    private static boolean isInit = false;
    private static final Object rootLock = new Object();
    private static final Object[] lockArray = new Object[32];
    public static final int STEP = 100;

    static {
        int i = 0;
        while (i < lockArray.length) {
            TablePrimaryKeyManager.lockArray[i] = new Object();
            ++i;
        }
    }

    public static Serializable newId(String tableName, Class idClass, SessionImplementor sessImpl) {
        try {
            TableKey tk = tableKeyMap.get(tableName);
            if (tk == null) {
                tk = TablePrimaryKeyManager.initTableKey(tableName, sessImpl);
            }
            long val = tk.currentIndex.getAndIncrement();
            while (val >= tk.maxIndex) {
                TablePrimaryKeyManager.initMaxIndex(sessImpl, tk, tableName);
                val = tk.currentIndex.getAndIncrement();
            }
            return TablePrimaryKeyManager.convertPrimaryKey(val, idClass);
        }
        catch (Exception ex) {
            throw new HibernateException((Throwable)ex);
        }
    }

    private static Object getTableLock(String tableName) {
        int hc = tableName.hashCode();
        if (hc < 0) {
            hc += Integer.MAX_VALUE;
        }
        return lockArray[hc % lockArray.length];
    }

    private static Serializable convertPrimaryKey(long val, Class idClass) {
        String value = String.valueOf(val);
        try {
            Constructor cons = idClass.getConstructor(String.class);
            return (Serializable)cons.newInstance(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Convert '" + value + "' to PrimaryKey for type " + idClass + " error.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableKey initTableKey(String tableName, SessionImplementor sessImpl) {
        Object object = TablePrimaryKeyManager.getTableLock(tableName);
        synchronized (object) {
            TableKey tk = tableKeyMap.get(tableName);
            if (tk != null) {
                return tk;
            }
            tk = new TableKey();
            TablePrimaryKeyManager.initMaxIndex(sessImpl, tk, tableName);
            tableKeyMap.put(tableName, tk);
            return tk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMaxIndex(SessionImplementor sessImpl, TableKey tk, String tableName) {
        Object object = TablePrimaryKeyManager.getTableLock(tableName);
        synchronized (object) {
            if (tk.maxIndex > 0L && tk.maxIndex > tk.currentIndex.get()) {
                return;
            }
            String startVal = TablePrimaryKeyManager.applyVal(tableName, sessImpl);
            tk.currentIndex = new AtomicLong(new Long(startVal));
            tk.maxIndex = tk.currentIndex.get() + 100L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String applyVal(String tableName, SessionImplementor sessImpl) {
        Object object = TablePrimaryKeyManager.getTableLock(tableName);
        synchronized (object) {
            Connection conn = null;
            try {
                conn = sessImpl.connection();
                if (!isInit) {
                    TablePrimaryKeyManager.initConfTable(conn);
                }
                ResultSet rs = conn.createStatement().executeQuery("select next_val from hb_pk_conf where table_name='" + tableName + "'");
                String nval = null;
                if (rs.next()) {
                    nval = rs.getObject(FIELD_NEXT_VAL).toString();
                    conn.createStatement().executeUpdate("update hb_pk_conf set next_val='" + (new Long(nval) + 100L) + "' where " + FIELD_TABLE_NAME + "='" + tableName + "'");
                } else {
                    nval = "10000";
                    conn.createStatement().executeUpdate("insert into hb_pk_conf(table_name,next_val) values('" + tableName + "','" + (new Long(nval) + 100L) + "')");
                }
                String string = nval;
                return string;
            }
            catch (SQLException e) {
                throw new HibernateException((Throwable)e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new HibernateException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConfTable(Connection conn) throws SQLException {
        Object object = rootLock;
        synchronized (object) {
            if (isInit) {
                return;
            }
            try {
                conn.createStatement().executeQuery("select max(next_val) from hb_pk_conf");
                isInit = true;
            }
            catch (Exception ex) {
                conn.createStatement().executeUpdate(TABLE_SQL);
                isInit = true;
            }
        }
    }

    private static class TableKey {
        AtomicLong currentIndex = null;
        volatile long maxIndex = 0L;

        private TableKey() {
        }
    }
}

