/*
 * Decompiled with CFR 0.152.
 */
package commons.hibernate;

import commons.hibernate.PKTable;
import commons.hibernate.TablePrimaryKeyManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablePrimaryKeyGenerator
implements IdentifierGenerator {
    private static Logger log = LoggerFactory.getLogger(TablePrimaryKeyGenerator.class);
    private volatile String tableName = null;
    private volatile Method idGetter = null;
    private volatile Class<?> idClass = null;

    public Serializable generate(SessionImplementor sessImpl, Object entity) throws HibernateException {
        if (this.tableName == null) {
            this.parseTableFiled(entity);
        }
        Serializable existVal = this.existValue(entity);
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(this.tableName) + " -> Exist val -> " + existVal);
        }
        if (existVal != null) {
            return existVal;
        }
        return TablePrimaryKeyManager.newId(this.tableName, this.idClass, sessImpl);
    }

    private Serializable existValue(Object entity) {
        try {
            return (Serializable)this.idGetter.invoke(entity, null);
        }
        catch (Exception e) {
            throw new HibernateException("test id value error : " + e);
        }
    }

    private void parseTableFiled(Object obj) {
        Method[] mds;
        PKTable pkTab = obj.getClass().getAnnotation(PKTable.class);
        if (pkTab != null) {
            this.tableName = pkTab.value();
        } else {
            Table tab = obj.getClass().getAnnotation(Table.class);
            if (tab == null) {
                throw new RuntimeException("Not found annotation (" + Table.class + ") in " + obj.getClass());
            }
            this.tableName = tab.name();
        }
        Method[] methodArray = mds = obj.getClass().getMethods();
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Id id = m.getAnnotation(Id.class);
            if (id != null) {
                this.idGetter = m;
                this.idClass = m.getReturnType();
                return;
            }
            ++n2;
        }
        throw new RuntimeException("Not found annotation (" + Table.class + ", " + Id.class + ") in " + obj.getClass());
    }
}

