/*
 * Decompiled with CFR 0.152.
 */
package commons.hibernate;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyGenerator
implements IdentifierGenerator {
    private static Logger log = LoggerFactory.getLogger(PrimaryKeyGenerator.class);
    private AtomicLong currentIndex = null;
    private String tableName = null;
    private String idName = null;
    private Class<?> idClass = null;

    public Serializable generate(SessionImplementor sessImpl, Object entity) throws HibernateException {
        if (this.currentIndex == null) {
            this.init(sessImpl, entity);
        }
        return this.convertPrimaryKey();
    }

    private synchronized void init(SessionImplementor sessImpl, Object entity) {
        if (this.currentIndex != null) {
            return;
        }
        this.parseTableFiled(entity);
        this.initCurrentIndex(sessImpl);
    }

    private Serializable convertPrimaryKey() {
        String value = String.valueOf(this.currentIndex.getAndIncrement());
        try {
            Constructor<?> cons = this.idClass.getConstructor(String.class);
            return (Serializable)cons.newInstance(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Convert '" + value + "' to PrimaryKey for type " + this.idClass + " error.", e);
        }
    }

    private void parseTableFiled(Object obj) {
        Method[] mds;
        Table tab = obj.getClass().getAnnotation(Table.class);
        if (tab == null) {
            throw new RuntimeException("Not found annotation (" + Table.class + ") in " + obj.getClass());
        }
        this.tableName = tab.name();
        Method[] methodArray = mds = obj.getClass().getMethods();
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Id id = m.getAnnotation(Id.class);
            if (id != null) {
                Column col = m.getAnnotation(Column.class);
                this.idName = col.name();
                this.idClass = m.getReturnType();
                return;
            }
            ++n2;
        }
        throw new RuntimeException("Not found annotation (" + Table.class + ", " + Id.class + ") in " + obj.getClass());
    }

    public void initCurrentIndex(SessionImplementor sessImpl) {
        String sql = "select max(" + this.idName + ") as max_id from " + this.tableName;
        if (log.isDebugEnabled()) {
            log.debug("Loading max value from " + this.tableName + " SQL [" + sql + "]");
        }
        Connection conn = null;
        try {
            try {
                conn = sessImpl.connection();
                PreparedStatement st = conn.prepareStatement(sql);
                ResultSet rs = st.executeQuery();
                if (rs.next()) {
                    Object maxObj = rs.getObject("max_id");
                    long curIx = Long.parseLong(maxObj == null ? "0" : maxObj.toString()) + 1L;
                    this.currentIndex = new AtomicLong(curIx);
                } else {
                    this.currentIndex = new AtomicLong(1L);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Initialize " + this.tableName + "'s primary key success! value=" + this.currentIndex.get());
                }
            }
            catch (SQLException e) {
                throw new HibernateException((Throwable)e);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new HibernateException((Throwable)e);
            }
        }
    }
}

