/*
 * Decompiled with CFR 0.152.
 */
package commons.hibernate;

import commons.db.Pager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageQuery {
    private static Logger log = LoggerFactory.getLogger(PageQuery.class);
    protected SessionFactory sessionFactory = null;
    private List<Param> params = new ArrayList<Param>();
    private String hql = null;
    private Pager pageVariable = null;

    public Pager getPager() {
        return this.pageVariable;
    }

    public PageQuery setPager(Pager pageVariable) {
        this.pageVariable = pageVariable;
        return this;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public PageQuery setHQL(String hql) {
        this.hql = hql;
        return this;
    }

    public PageQuery setParam(String name, Object value, Type type) {
        this.params.add(new Param(name, value, type));
        return this;
    }

    private Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public List<?> listAll() {
        Query query = this.getSession().createQuery(this.hql);
        this.setParameters(query);
        return query.list();
    }

    public List<?> list() {
        Query query = this.getSession().createQuery(this.hql);
        this.setParameters(query);
        if (this.pageVariable != null) {
            int count = this.mathRowsCount();
            if (count < 1) {
                return null;
            }
            int first = (this.pageVariable.getCurrentPage() - 1) * this.pageVariable.getRecordPerPage();
            if (first < 0 || count - first < 0) {
                first = 0;
            }
            this.mathPageVar(first, count);
            query.setFirstResult(first);
            query.setMaxResults(this.pageVariable.getRecordPerPage());
        }
        return query.list();
    }

    private void mathPageVar(int first, int count) {
        this.pageVariable.setRecordCount(count);
        this.pageVariable.setRecordCountCurrentPage(this.pageVariable.getRecordPerPage());
        if (first + this.pageVariable.getRecordPerPage() > count) {
            this.pageVariable.setRecordCountCurrentPage(count - first);
        }
        int pages = count / this.pageVariable.getRecordPerPage();
        if (count % this.pageVariable.getRecordPerPage() != 0) {
            ++pages;
        }
        this.pageVariable.setPageCount(pages);
    }

    protected int mathRowsCount() {
        int fb;
        this.hql = this.hql.trim();
        String tql = this.hql.toLowerCase();
        String fields = "*";
        int fa = tql.indexOf("from ");
        if (fa != 0) {
            fa = tql.indexOf(" from ");
            fields = this.hql.substring(6, fa).trim();
            String string = fields = fields.toLowerCase().startsWith("distinct ") ? fields : "*";
        }
        if ((fb = tql.indexOf(" order ", fa)) < 0) {
            fb = tql.length();
        }
        tql = "select count(" + fields + ") " + this.hql.substring(fa, fb);
        if (log.isDebugEnabled()) {
            log.debug("[ Count Hql ] " + tql);
        }
        Query query = this.getSession().createQuery(tql);
        this.setParameters(query);
        Object tcount = query.setMaxResults(1).uniqueResult();
        return tcount != null ? Integer.parseInt(tcount.toString()) : 0;
    }

    private void setParameters(Query q) {
        for (Param pm : this.params) {
            pm.doSet(q);
        }
    }

    public PageQuery setString(String name, String value) {
        return this.setParam(name, value, Type.String);
    }

    public PageQuery setCharacter(String name, char value) {
        return this.setParam(name, Character.valueOf(value), Type.Character);
    }

    public PageQuery setLong(String name, Long value) {
        return this.setParam(name, value, Type.Long);
    }

    public PageQuery setInteger(String name, int value) {
        return this.setParam(name, value, Type.Integer);
    }

    public PageQuery setBigDecimal(String name, BigDecimal value) {
        return this.setParam(name, value, Type.Bigdecimal);
    }

    public PageQuery setDate(String name, Date value) {
        return this.setParam(name, value, Type.Date);
    }

    public PageQuery setTimestamp(String name, Date value) {
        return this.setParam(name, value, Type.Timestamp);
    }

    public PageQuery setParameterList(String name, Collection<?> value) {
        return this.setParam(name, value, Type.Collection);
    }

    public PageQuery setParameterList(String name, Object[] value) {
        return this.setParam(name, value, Type.Array);
    }

    class Param {
        private String name = null;
        private Object value = null;
        private Type type = null;

        public Param(String name, Object value, Type type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public void doSet(Query query) {
            if (this.type.ordinal() == Type.String.ordinal()) {
                query.setString(this.name, (String)this.value);
                return;
            }
            if (this.type.ordinal() == Type.Character.ordinal()) {
                query.setCharacter(this.name, ((Character)this.value).charValue());
                return;
            }
            if (this.type.ordinal() == Type.Integer.ordinal()) {
                query.setInteger(this.name, ((Integer)this.value).intValue());
                return;
            }
            if (this.type.ordinal() == Type.Bigdecimal.ordinal()) {
                query.setBigDecimal(this.name, (BigDecimal)this.value);
                return;
            }
            if (this.type.ordinal() == Type.Array.ordinal()) {
                query.setParameterList(this.name, (Object[])this.value);
                return;
            }
            if (this.type.ordinal() == Type.Collection.ordinal()) {
                query.setParameterList(this.name, (Collection)this.value);
                return;
            }
            if (this.type.ordinal() == Type.Long.ordinal()) {
                query.setLong(this.name, ((Long)this.value).longValue());
                return;
            }
            if (this.type.ordinal() == Type.Date.ordinal()) {
                query.setDate(this.name, (Date)this.value);
                return;
            }
            if (this.type.ordinal() == Type.Timestamp.ordinal()) {
                query.setTimestamp(this.name, (Date)this.value);
            }
        }
    }

    public static enum Type {
        Long,
        Integer,
        String,
        Character,
        Date,
        Bigdecimal,
        Collection,
        Array,
        Timestamp;

    }
}

