/*
 * Decompiled with CFR 0.152.
 */
package commons.hibernate;

import java.lang.reflect.Method;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyPropertyClear {
    private static final Logger log = LoggerFactory.getLogger(EmptyPropertyClear.class);

    public static void scanAndClear(Object target) {
        if (target == null) {
            return;
        }
        try {
            Method[] mhs;
            Method[] methodArray = mhs = target.getClass().getMethods();
            int n = mhs.length;
            int n2 = 0;
            while (n2 < n) {
                Method mh = methodArray[n2];
                if (mh.getAnnotation(ManyToOne.class) != null) {
                    Object proObj;
                    if (log.isDebugEnabled()) {
                        log.debug("Scan a ManyToOne property -> " + mh.getName());
                    }
                    if ((proObj = mh.invoke(target, null)) == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("ManyToOne property is null -> " + mh.getName());
                        }
                    } else {
                        Method proIdMh = EmptyPropertyClear.findIDMethod(mh.getReturnType());
                        if (proIdMh == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("ManyToOne property " + mh.getReturnType().getName() + " not have 'Id' property.");
                            }
                        } else {
                            Object idObj = proIdMh.invoke(proObj, null);
                            if (idObj == null || "".equals(idObj.toString())) {
                                String setStr = "s" + mh.getName().substring(1);
                                Method setMh = target.getClass().getMethod(setStr, mh.getReturnType());
                                Object[] args = new Object[1];
                                setMh.invoke(target, args);
                                if (log.isDebugEnabled()) {
                                    log.debug("#### Clear property -> " + mh.getName());
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Method findIDMethod(Class clazz) {
        Method[] mhs;
        Method[] methodArray = mhs = clazz.getMethods();
        int n = mhs.length;
        int n2 = 0;
        while (n2 < n) {
            Method mh = methodArray[n2];
            if (mh.getAnnotation(Id.class) != null) {
                return mh;
            }
            ++n2;
        }
        return null;
    }
}

