/*
 * Decompiled with CFR 0.152.
 */
package commons.hibernate;

import commons.hibernate.DBLog;
import commons.hibernate.EmptyPropertyClear;
import commons.hibernate.PageQuery;
import commons.tags.PagerFilter;
import java.io.Serializable;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DBService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected SessionFactory sessionFactory = null;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public PageQuery createPageQuery() {
        PageQuery pq = new PageQuery();
        pq.setSessionFactory(this.sessionFactory);
        pq.setPager(PagerFilter.getPager());
        return pq;
    }

    public Query createQuery(String hql) {
        return this.getSession().createQuery(hql);
    }

    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @Transactional
    public void saveObject(Object ... objArray) {
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            EmptyPropertyClear.scanAndClear(obj);
            this.getSession().save(obj);
            ++n2;
        }
    }

    @Transactional
    public void deleteObject(Object ... objArray) {
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            EmptyPropertyClear.scanAndClear(obj);
            this.getSession().delete(obj);
            ++n2;
        }
    }

    @Transactional
    public void updateObject(Object ... objArray) {
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            EmptyPropertyClear.scanAndClear(obj);
            this.getSession().update(obj);
            ++n2;
        }
    }

    @Transactional
    public void saveOrUpdateObject(Object ... objArray) {
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            EmptyPropertyClear.scanAndClear(obj);
            this.getSession().saveOrUpdate(obj);
            ++n2;
        }
    }

    @Transactional
    public void deleteObject(DBLog log, Object ... objArray) {
        this.getSession().save((Object)log);
        this.deleteObject(objArray);
    }

    @Transactional
    public void updateObject(DBLog log, Object ... objArray) {
        this.getSession().save((Object)log);
        this.updateObject(objArray);
    }

    @Transactional
    public void saveOrUpdateObject(DBLog log, Object ... objArray) {
        this.getSession().save((Object)log);
        this.saveOrUpdateObject(objArray);
    }

    public Object getObject(Class<?> clazz, Serializable pk) {
        return this.getSession().get(clazz, pk);
    }

    public Object loadObject(Class<?> clazz, Serializable pk) {
        return this.getSession().load(clazz, pk);
    }
}

