/*
 * Decompiled with CFR 0.152.
 */
package commons.excel;

import commons.excel.ExcelValidator;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SampleExcelValidator
implements ExcelValidator {
    private static Logger log = Logger.getLogger(SampleExcelValidator.class);
    private String separator = ";";
    private String titles;
    private String patterns;
    private Pattern[] patternArray;
    private String[] titleArray;

    public void init() {
        if (this.titles != null) {
            this.titleArray = this.titles.split(this.separator);
        }
        if (this.patterns != null) {
            String[] ss = this.patterns.split(this.separator);
            this.patternArray = new Pattern[ss.length];
            int i = 0;
            while (i < ss.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("regex_" + i + " -> [" + ss[i] + "]"));
                }
                this.patternArray[i] = Pattern.compile(ss[i]);
                ++i;
            }
        }
        if (this.patternArray != null && this.titleArray != null && this.patternArray.length != this.titleArray.length) {
            throw new IllegalArgumentException("patternArray.length=" + this.patternArray.length + ", titleArray.length=" + this.titleArray.length);
        }
    }

    @Override
    public Pattern[] getDataPattern() {
        return this.patternArray;
    }

    @Override
    public String[] getTitle() {
        return this.titleArray;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getTitles() {
        return this.titles;
    }

    public void setTitles(String titles) {
        this.titles = titles;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }
}

