/*
 * Decompiled with CFR 0.152.
 */
package commons.excel;

import commons.excel.ExcelParseResult;
import commons.excel.ExcelValidator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.log4j.Logger;

public class ExcelParser {
    static Logger log = Logger.getLogger(ExcelParser.class);
    private static TimeZone tzone = TimeZone.getTimeZone("GMT+8:00");
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    static {
        DATE_FORMAT.setTimeZone(tzone);
        DATE_TIME_FORMAT.setTimeZone(tzone);
    }

    public static void main(String[] args) throws FileNotFoundException {
        List<String[]> sss = ExcelParser.parse(new FileInputStream("C:/Documents and Settings/zw/\u684c\u9762/temp/\u5458\u5de5.xls"));
        for (Object[] objectArray : sss) {
            System.out.println(Arrays.toString(objectArray));
        }
    }

    public static List<String[]> parse(InputStream inputStream) {
        ArrayList<String[]> res = new ArrayList<String[]>();
        try {
            try {
                Workbook book = Workbook.getWorkbook((InputStream)inputStream);
                Sheet sheet = book.getSheet(0);
                int emptyRows = 0;
                String[] emptyRowData = null;
                int i = 0;
                int ni = sheet.getRows();
                while (i < ni) {
                    String[] row = new String[sheet.getColumns()];
                    int j = 0;
                    int nj = sheet.getColumns();
                    while (j < nj) {
                        Cell cell = sheet.getCell(j, i);
                        if (cell.getType().equals(CellType.DATE)) {
                            DateCell dcell = (DateCell)cell;
                            Date tdate = dcell.getDate();
                            if (tdate != null) {
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(tdate);
                                cal.setTimeZone(tzone);
                                row[j] = cal.get(11) > 0 || cal.get(12) > 0 || cal.get(13) > 0 ? DATE_TIME_FORMAT.format(cal.getTime()) : DATE_FORMAT.format(cal.getTime());
                            } else {
                                row[j] = "";
                            }
                        } else {
                            row[j] = cell.getContents();
                        }
                        row[j] = row[j] != null ? row[j].trim().replaceAll("\u3000*$", "").replaceAll("^\u3000*", "") : "";
                        ++j;
                    }
                    if (ExcelParser.isEmptyRow(row)) {
                        emptyRowData = row;
                        ++emptyRows;
                    } else {
                        if (emptyRows > 0) {
                            int x = 0;
                            while (x < emptyRows) {
                                res.add(emptyRowData);
                                ++x;
                            }
                        }
                        res.add(row);
                        emptyRows = 0;
                    }
                    ++i;
                }
                book.close();
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return res;
    }

    public static ExcelParseResult parse(InputStream inputStream, ExcelValidator excelValidator) {
        List<String[]> data = ExcelParser.parse(inputStream);
        if (data == null || data.size() < 1 || excelValidator == null) {
            return new ExcelParseResult(true, null, null, data);
        }
        if (excelValidator.getTitle() != null && excelValidator.getDataPattern() != null && excelValidator.getTitle().length != excelValidator.getDataPattern().length) {
            throw new IllegalArgumentException("Illegal argument ExcelValidator");
        }
        ExcelParseResult res = new ExcelParseResult();
        res.setData(data);
        res.setValidate(true);
        if (excelValidator.getTitle() != null) {
            String[] titleVal;
            String[] titleRow = data.get(0);
            if (titleRow.length != (titleVal = excelValidator.getTitle()).length) {
                int col = titleRow.length > titleVal.length ? titleVal.length : titleRow.length;
                res.addErrorLine(0, col, titleRow);
                return res;
            }
            int i = 0;
            while (i < titleRow.length) {
                if (!titleRow[i].equals(titleVal[i])) {
                    res.addErrorLine(0, i, titleRow);
                    return res;
                }
                ++i;
            }
        }
        int curline = excelValidator.getTitle() != null ? 1 : 0;
        Pattern[] pts = excelValidator.getDataPattern();
        if (pts != null && data.size() > curline) {
            while (curline < data.size()) {
                String[] row = data.get(curline);
                if (row.length != pts.length) {
                    int col = row.length > pts.length ? pts.length : row.length;
                    res.addErrorLine(curline, col, row);
                } else {
                    int i = 0;
                    while (i < pts.length) {
                        if (!pts[i].matcher(row[i]).matches()) {
                            res.addErrorLine(curline, i, row);
                            break;
                        }
                        ++i;
                    }
                }
                ++curline;
            }
        }
        return res;
    }

    private static boolean isEmptyRow(String[] row) {
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!"".equals(s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

