/*
 * Decompiled with CFR 0.152.
 */
package commons.excel;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelGenerator {
    public static byte[] generate(SheetData ... sheetArray) throws IOException, RowsExceededException, WriteException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)bos);
        WritableFont wfont = new WritableFont(WritableFont.ARIAL, 9, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
        WritableCellFormat wcfFC = new WritableCellFormat(wfont);
        wcfFC.setBorder(Border.ALL, BorderLineStyle.THIN);
        wcfFC.setVerticalAlignment(VerticalAlignment.CENTRE);
        int sheetIx = 0;
        SheetData[] sheetDataArray = sheetArray;
        int n = sheetArray.length;
        int n2 = 0;
        while (n2 < n) {
            SheetData sd = sheetDataArray[n2];
            WritableSheet wsheet = wbook.createSheet(sd.getTitle(), sheetIx++);
            int rowNum = 0;
            int i = 0;
            while (sd.getData() != null && i < sd.getData().size()) {
                String[] row = sd.getData().get(i);
                int j = 0;
                while (row != null && j < row.length) {
                    BigDecimal tnum = ExcelGenerator.toNum(row[j]);
                    if (tnum != null) {
                        wsheet.addCell((WritableCell)new Number(j, rowNum, tnum.doubleValue(), (CellFormat)wcfFC));
                    } else {
                        wsheet.addCell((WritableCell)new Label(j, rowNum, row[j], (CellFormat)wcfFC));
                    }
                    ++j;
                }
                ++rowNum;
                ++i;
            }
            ++n2;
        }
        wbook.write();
        wbook.close();
        return bos.toByteArray();
    }

    private static BigDecimal toNum(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new BigDecimal(str);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void main2(String[] args) throws RowsExceededException, WriteException, IOException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        rows.add(new String[]{"\u6807\u98981", "\u6807\u98982\n\u6362\u884c\u4e86", "\u6807\u98983"});
        rows.add(new String[]{"A1", "A2"});
        rows.add(new String[]{"B1", "B2", "B3", "B4"});
        String[] stringArray = new String[3];
        stringArray[0] = "C1";
        stringArray[2] = "C4";
        rows.add(stringArray);
        SheetData sd1 = new SheetData("\u8fd9\u662fsheet1", rows);
        ArrayList<String[]> rows2 = new ArrayList<String[]>();
        rows2.add(new String[]{"\u6807\u98981", "\u6807\u98982", "\u6807\u98983"});
        rows2.add(new String[]{"A1", "A2"});
        SheetData sd2 = new SheetData("\u8fd9\u662fsheet2", rows2);
        byte[] data = ExcelGenerator.generate(sd1, sd2);
        FileOutputStream fos = new FileOutputStream("d:/ttt.xls");
        fos.write(data);
        fos.close();
    }

    public static class SheetData {
        private final String title;
        private final List<String[]> data;

        public SheetData(String title, List<String[]> data) {
            this.title = title;
            this.data = data;
        }

        public String getTitle() {
            return this.title;
        }

        public List<String[]> getData() {
            return this.data;
        }
    }
}

