/*
 * Decompiled with CFR 0.152.
 */
package commons.enums;

import commons.enums.CodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeEnumUtil {
    private static Logger log = LoggerFactory.getLogger(CodeEnumUtil.class);

    public static <T extends CodeEnum> T[] list(Class<? extends CodeEnum> codeEnumClazz) {
        if (codeEnumClazz == null) {
            return null;
        }
        CodeEnumUtil.enumCheck(codeEnumClazz);
        try {
            return (CodeEnum[])codeEnumClazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static <T extends CodeEnum> T find(Class<? extends CodeEnum> codeEnumClazz, String code) {
        if (code == null || codeEnumClazz == null) {
            return null;
        }
        return CodeEnumUtil.find(CodeEnumUtil.list(codeEnumClazz), code);
    }

    public static <T extends CodeEnum> T find(CodeEnum[] codeEnums, String code) {
        if (code == null || codeEnums == null) {
            return null;
        }
        CodeEnum[] codeEnumArray = codeEnums;
        int n = codeEnums.length;
        int n2 = 0;
        while (n2 < n) {
            CodeEnum ce = codeEnumArray[n2];
            if (code.equals(ce.getCode())) {
                return (T)ce;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isEnum(Class<? extends Object> clazz) {
        return Enum.class.equals(clazz.getSuperclass());
    }

    private static void enumCheck(Class<? extends Object> clazz) {
        if (!CodeEnumUtil.isEnum(clazz)) {
            throw new IllegalArgumentException(clazz + " is not a java enum.");
        }
    }
}

