/*
 * Decompiled with CFR 0.152.
 */
package commons.crypto;

import commons.crypto.ByteUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;

public class RSAUtil {
    private static final String CIPHER_INSTANCE_KEY = "RSA/ECB/PKCS1Padding";
    public static final String PUBLIC_EXPONENT_1024_HEX = "010001";

    public static KeyPair generateKeyPair(int keylen) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(keylen);
        return kpg.generateKeyPair();
    }

    public static RSAPublicKey loadPublicKey(String modulusHex, String exponentHex) throws Exception {
        KeyFactory keyFac = KeyFactory.getInstance("RSA");
        BigInteger mod = new BigInteger(modulusHex, 16);
        BigInteger exp = new BigInteger(exponentHex, 16);
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(mod, exp);
        return (RSAPublicKey)keyFac.generatePublic(pubKeySpec);
    }

    public static RSAPrivateKey loadPrivateKey(String modulusHex, String exponentHex) throws Exception {
        KeyFactory keyFac = KeyFactory.getInstance("RSA");
        BigInteger mod = new BigInteger(modulusHex, 16);
        BigInteger exp = new BigInteger(exponentHex, 16);
        RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(mod, exp);
        return (RSAPrivateKey)keyFac.generatePrivate(priKeySpec);
    }

    public static Key loadKey(String modulusHex, String exponentHex) throws Exception {
        return exponentHex.length() > 10 ? RSAUtil.loadPrivateKey(modulusHex, exponentHex) : RSAUtil.loadPublicKey(modulusHex, exponentHex);
    }

    public static byte[] encrypt(Key key, byte[] data) throws Exception {
        Cipher cp = Cipher.getInstance(CIPHER_INSTANCE_KEY);
        cp.init(1, key);
        return cp.doFinal(data);
    }

    public static byte[] encrypt(String modulusHex, String exponentHex, byte[] data) throws Exception {
        return RSAUtil.encrypt(RSAUtil.loadKey(modulusHex, exponentHex), data);
    }

    public static byte[] decrypt(Key key, byte[] data) throws Exception {
        Cipher cp = Cipher.getInstance(CIPHER_INSTANCE_KEY);
        cp.init(2, key);
        return cp.doFinal(data);
    }

    public static byte[] decrypt(String modulusHex, String exponentHex, byte[] data) throws Exception {
        return RSAUtil.decrypt(RSAUtil.loadKey(modulusHex, exponentHex), data);
    }

    public static byte[] sign(PrivateKey key, byte[] data) throws Exception {
        byte[] md5 = RSAUtil.md5(data);
        return RSAUtil.encrypt(key, md5);
    }

    public static boolean verify(PublicKey key, byte[] data, byte[] sign) throws Exception {
        byte[] md5Src = RSAUtil.decrypt(key, sign);
        byte[] md5The = RSAUtil.md5(data);
        return Arrays.equals(md5Src, md5The);
    }

    public static byte[] md5(byte[] data) {
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(data);
            return mdTemp.digest();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] simpleCrypt(Key key, byte[] data) {
        BigInteger mod;
        BigInteger exp;
        if (key instanceof RSAPublicKey) {
            exp = ((RSAPublicKey)key).getPublicExponent();
            mod = ((RSAPublicKey)key).getModulus();
        } else {
            exp = ((RSAPrivateKey)key).getPrivateExponent();
            mod = ((RSAPrivateKey)key).getModulus();
        }
        BigInteger dataInt = new BigInteger(1, data);
        BigInteger res = dataInt.modPow(exp, mod);
        return res.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        KeyPair kp = RSAUtil.generateKeyPair(1024);
        String pubM = ByteUtil.byteToHex(((RSAPublicKey)kp.getPublic()).getModulus().toByteArray());
        System.out.println("public_key_modules = " + pubM);
        String pubE = ByteUtil.byteToHex(((RSAPublicKey)kp.getPublic()).getPublicExponent().toByteArray());
        System.out.println("public_key_exponent = " + pubE);
        String priM = ByteUtil.byteToHex(((RSAPrivateKey)kp.getPrivate()).getModulus().toByteArray());
        System.out.println("private_key_modules = " + priM);
        String priE = ByteUtil.byteToHex(((RSAPrivateKey)kp.getPrivate()).getPrivateExponent().toByteArray());
        System.out.println("private_key_exponent = " + priE);
    }
}

