/*
 * Decompiled with CFR 0.152.
 */
package commons.crypto;

public class ByteUtil {
    public static byte[] hexToByte(String hex) {
        if (hex.length() % 2 == 1) {
            hex = "0" + hex;
        }
        byte[] res = new byte[hex.length() / 2];
        int i = 0;
        int n = hex.length();
        while (i < n) {
            res[i / 2] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
            i += 2;
        }
        return res;
    }

    public static String byteToHex(byte[] bs) {
        if (bs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bs.length) {
            int nn = bs[i] < 0 ? bs[i] + 256 : bs[i];
            String t = Integer.toHexString(nn).toUpperCase();
            sb.append(t.length() < 2 ? "0" + t : t);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] union(byte[] ... bss) {
        int nx = 0;
        byte[][] byArray = bss;
        int n = bss.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] bs = byArray[n2];
            nx += bs.length;
            ++n2;
        }
        byte[] res = new byte[nx];
        nx = 0;
        byte[][] byArray2 = bss;
        int n3 = bss.length;
        n = 0;
        while (n < n3) {
            byte[] bs = byArray2[n];
            if (bs != null && bs.length >= 1) {
                System.arraycopy(bs, 0, res, nx, bs.length);
                nx += bs.length;
            }
            ++n;
        }
        return res;
    }

    public static byte[] sub(byte[] bs, int first, int length) {
        if (bs.length - first < length) {
            throw new RuntimeException("Out of byte[], bs.length=" + bs.length + ", first=" + first + ", length=" + length);
        }
        length = first + length > bs.length ? bs.length - first : length;
        byte[] nb = new byte[length];
        System.arraycopy(bs, first, nb, 0, length);
        return nb;
    }

    public static byte[] trimByte(byte[] bs, byte trimByte, boolean isLeft) {
        if (isLeft) {
            int i = 0;
            while (i < bs.length && bs[i] == trimByte) {
                ++i;
            }
            bs = ByteUtil.sub(bs, i, bs.length - i);
        } else {
            int i = bs.length - 1;
            while (i >= 0 && bs[i] == trimByte) {
                --i;
            }
            bs = ByteUtil.sub(bs, 0, i + 1);
        }
        return bs;
    }
}

