/*
 * Decompiled with CFR 0.152.
 */
package code.web.vm;

import code.CodeException;
import code.Config;
import code.tree.ClickMatcher;
import code.tree.TreeConfig;
import code.util.CodeUtil;
import code.util.JSEscapeUtil;
import code.util.SpringUtil;
import code.util.db.DBUtil;
import code.util.db.QueryResult;
import code.web.VmAction;
import code.web.vm.TreeNode;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class TreeAction
implements VmAction {
    @Override
    public void execute(VelocityContext context, HttpServletRequest req) {
        TreeConfig config = (TreeConfig)SpringUtil.getBean(req.getParameter("key"));
        QueryResult qr = this.queryData(config);
        context.put("nodes", this.convert(qr, config));
        context.put("expandAll", (Object)config.isExpandAll());
    }

    private List<TreeNode> convert(QueryResult qr, TreeConfig config) {
        if (qr.data == null || qr.data.size() < 1) {
            return null;
        }
        int idIndex = CodeUtil.getFieldIndex(config.getIdField(), qr.head);
        int pidIndex = CodeUtil.getFieldIndex(config.getPidField(), qr.head);
        int nameIndex = CodeUtil.getFieldIndex(config.getNameField(), qr.head);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Object o : qr.data) {
            Object[] oo = (Object[])o;
            TreeNode node = new TreeNode();
            node.setId(oo[idIndex] != null ? "" + oo[idIndex] : null);
            node.setPid(oo[pidIndex] != null ? "" + oo[pidIndex] : null);
            node.setName(JSEscapeUtil.escape(oo[nameIndex] != null ? "" + oo[nameIndex] : null));
            node.setParent(this.isParent(oo, config, qr));
            node.setCanClick(this.canClick(oo, config, qr));
            nodes.add(node);
        }
        return nodes;
    }

    public boolean canClick(Object[] oo, TreeConfig config, QueryResult qr) {
        boolean isFilter;
        boolean bl = isFilter = !config.isClickFilter();
        if (config.getClickMatchers() != null) {
            ClickMatcher[] clickMatcherArray = config.getClickMatchers();
            int n = clickMatcherArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClickMatcher cm = clickMatcherArray[n2];
                if (cm.isMatch(oo, qr.head)) {
                    isFilter = config.isClickFilter();
                    break;
                }
                ++n2;
            }
        }
        return !isFilter;
    }

    public boolean isParent(Object[] node, TreeConfig config, QueryResult qr) {
        if (config.getFolderAware() != null) {
            return config.getFolderAware().isFolder(node, qr.head);
        }
        return false;
    }

    protected QueryResult queryData(TreeConfig config) {
        DBUtil dbu = (DBUtil)SpringUtil.getBean(SpringUtil.DBUTIL_NAME);
        try {
            Config.SqlData sd = config.generateSql();
            QueryResult queryResult = dbu.createOperator(sd.sql).setParameter(sd.paramMap).query();
            return queryResult;
        }
        catch (Exception e) {
            if (e instanceof CodeException) {
                throw (CodeException)e;
            }
            throw new CodeException("\u67e5\u8be2\u6570\u636e\u5e93\u53d1\u751f\u5f02\u5e38\uff01", e);
        }
        finally {
            dbu.close();
        }
    }
}

