/*
 * Decompiled with CFR 0.152.
 */
package code.web;

import code.web.ResourceUtil;
import code.web.VmAction;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmProcessor {
    private static Logger log = LoggerFactory.getLogger(VmProcessor.class);
    private static Throwable initException = null;
    public static final String VM_CONTEXT_CODE_PATH = "codePath";
    public static final String VM_CONTEXT_HTTP_REQUEST = "request";
    public static final String VM_FILE_SUFFIX = ".htm";

    static {
        try {
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)new NullLogChute());
            Velocity.init();
        }
        catch (Throwable e) {
            log.error("Initalize Velocity error.", e);
            initException = e;
        }
    }

    public static void process(HttpServletRequest req, HttpServletResponse resp, String codePathPrefix, String encoding) {
        if (initException != null) {
            throw new RuntimeException(initException);
        }
        try {
            VmProcessor.process0(req, resp, codePathPrefix, encoding);
        }
        catch (Throwable ex) {
            log.error("", ex);
        }
    }

    public static void process0(HttpServletRequest req, HttpServletResponse resp, String codePathPrefix, String encoding) throws Exception {
        String vmPath = req.getRequestURI().substring(codePathPrefix.length());
        byte[] vmBytes = ResourceUtil.getResource(vmPath);
        if (vmBytes.length < 1) {
            log.warn("Not found vm file [" + vmPath + "]");
            return;
        }
        VelocityContext context = new VelocityContext();
        context.put(VM_CONTEXT_CODE_PATH, (Object)codePathPrefix);
        context.put(VM_CONTEXT_HTTP_REQUEST, (Object)req);
        VmProcessor.executeAction(context, req, vmPath);
        StringWriter sw = new StringWriter();
        StringReader sr = new StringReader(new String(vmBytes, "UTF-8"));
        Velocity.evaluate((Context)context, (Writer)sw, (String)VmProcessor.class.getName(), (Reader)sr);
        resp.getOutputStream().write(sw.toString().getBytes(encoding));
    }

    private static void executeAction(VelocityContext context, HttpServletRequest req, String vmPath) {
        VmAction action;
        block3: {
            action = null;
            try {
                String acName = vmPath.substring("vm/".length());
                acName = acName.substring(0, acName.length() - VM_FILE_SUFFIX.length());
                String acClass = "code.web.vm." + acName + "Action";
                action = (VmAction)Class.forName(acClass).newInstance();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Not found VmAction for " + vmPath + ". " + ex.getMessage());
            }
        }
        if (action != null) {
            action.execute(context, req);
        }
    }
}

