/*
 * Decompiled with CFR 0.152.
 */
package code.web;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static Logger log = LoggerFactory.getLogger(ResourceUtil.class);
    public static final String URI_PREFIX = "resources/";
    private static ConcurrentHashMap<String, byte[]> cache = new ConcurrentHashMap();
    private static byte[] EMPTY_BS = new byte[0];

    public static byte[] getResource(String path) {
        ClassLoader cl;
        InputStream is;
        byte[] res = cache.get(path);
        if (res != null) {
            return res;
        }
        if (log.isDebugEnabled()) {
            log.debug("loading resource [" + path + "]");
        }
        if ((is = (cl = ResourceUtil.class.getClassLoader()).getResourceAsStream(URI_PREFIX + path)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Not found resource [" + path + "]");
            }
            cache.put(path, EMPTY_BS);
            return EMPTY_BS;
        }
        res = ResourceUtil.readIS(is, path);
        cache.put(path, res);
        return res;
    }

    private static byte[] readIS(InputStream is, String path) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] bs = new byte[10240];
            int n = -1;
            while ((n = is.read(bs)) > 0) {
                bos.write(bs, 0, n);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            log.error("Read bytes error [" + path + "]", (Throwable)ex);
            byte[] byArray = EMPTY_BS;
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        byte[] bs = ResourceUtil.getResource("static/ztree/jquery-1.4.2.js");
        System.out.println(new String(bs));
    }
}

