/*
 * Decompiled with CFR 0.152.
 */
package code.web;

import code.web.ResourceUtil;
import code.web.VmProcessor;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(CodeFilter.class);
    static final String TYPE_STATIC = "static/";
    static final String TYPE_VM = "vm/";
    public static final String INIT_PARAM_PATH = "path";
    public static final String INIT_PARAM_ENCODING = "encoding";
    public static final String RESOURCE_ENCODING = "UTF-8";
    private String codePathPrefix;
    private String encoding = "UTF-8";
    public static final ThreadLocal<HttpServletRequest> httpRequest = new ThreadLocal();
    private static String[] IMAGE_NAMES = new String[]{"gif", "png", "jpg", "jpeg"};

    public static HttpServletRequest getHttpServletRequest() {
        return httpRequest.get();
    }

    public void init(FilterConfig conf) throws ServletException {
        String ccp = conf.getInitParameter(INIT_PARAM_PATH);
        if (StringUtils.isBlank((String)ccp)) {
            throw new IllegalArgumentException("Can not initialize CodeFilter, init-param 'path' is empty.");
        }
        if (!(ccp = ccp.trim()).startsWith("/")) {
            ccp = "/" + ccp;
        }
        if (!ccp.endsWith("/")) {
            ccp = String.valueOf(ccp) + "/";
        }
        this.codePathPrefix = String.valueOf(conf.getServletContext().getContextPath()) + ccp;
        conf.getServletContext().log("[CodeFilter] code_path_prefix is [" + this.codePathPrefix + "]");
        String enc = conf.getInitParameter(INIT_PARAM_ENCODING);
        if (StringUtils.isNotBlank((String)enc)) {
            this.encoding = enc.trim();
        }
        conf.getServletContext().log("[CodeFilter] encoding is [" + this.encoding + "]");
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)req;
        if (hreq.getRequestURI().startsWith(this.codePathPrefix)) {
            httpRequest.set(hreq);
            try {
                this.process(hreq, (HttpServletResponse)resp);
            }
            finally {
                httpRequest.set(null);
            }
        } else {
            chain.doFilter(req, resp);
        }
    }

    private void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String subUri = req.getRequestURI().substring(this.codePathPrefix.length());
        if (subUri.startsWith(TYPE_STATIC)) {
            this.staticProcess(resp, subUri);
        } else if (subUri.startsWith(TYPE_VM)) {
            VmProcessor.process(req, resp, this.codePathPrefix, this.encoding);
        } else {
            log.warn("Can not process uri [" + req.getRequestURI() + "]");
            resp.getWriter().write("Bad request");
        }
    }

    private boolean isImage(String subUri, HttpServletResponse resp, byte[] data) throws IOException {
        int nx = subUri.lastIndexOf(".");
        if (nx == -1) {
            return false;
        }
        String suffix = subUri.substring(nx + 1).toLowerCase();
        boolean isImg = false;
        String[] stringArray = IMAGE_NAMES;
        int n = IMAGE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (i.equals(suffix)) {
                isImg = true;
                break;
            }
            ++n2;
        }
        if (isImg) {
            resp.setContentType("image/" + suffix);
            resp.getOutputStream().write(data);
        }
        return isImg;
    }

    private void staticProcess(HttpServletResponse resp, String subUri) {
        try {
            byte[] data = ResourceUtil.getResource(subUri);
            if (this.isImage(subUri, resp, data)) {
                return;
            }
            String dataStr = new String(data, RESOURCE_ENCODING);
            resp.getOutputStream().write(dataStr.getBytes(this.encoding));
        }
        catch (Exception ex) {
            log.warn("static file process error : " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
    }

    public void destroy() {
    }
}

