/*
 * Decompiled with CFR 0.152.
 */
package code.util.tree;

import code.util.tree.TreeData;
import code.util.tree.TreeImages;
import java.util.List;
import java.util.UUID;

public class TreeCreater {
    public static final String SPACE = "&nbsp;";
    private static final String onClickFunName = "ck_tree_zw_on";

    public static String getHtml(TreeData tdata, TreeImages timg) {
        StringBuffer sb = new StringBuffer();
        TreeCreater.insertRoot(sb, timg, tdata);
        TreeCreater.insertBody("", null, sb, timg, tdata);
        return sb.toString();
    }

    public static String getJs(TreeImages timg) {
        StringBuffer jb = new StringBuffer();
        jb.append("<script language='javascript'>");
        jb.append("function ck_tree_zw_on(id){");
        jb.append("dpFlag=document.getElementById(id).style.display;");
        jb.append("document.getElementById(id).style.display=dpFlag=='none'?'':'none';");
        jb.append("lineImg=document.getElementById(id+'_line');");
        jb.append("plusImg='" + timg.getPlusLast() + "';");
        jb.append("minusImg='" + timg.getMinusLast() + "';");
        jb.append("pn=plusImg.lastIndexOf('/');");
        jb.append("mn=minusImg.lastIndexOf('/');");
        jb.append("plusKey=pn!=-1?plusImg.substring(pn+1):plusImg;");
        jb.append("minusKey=pn!=-1?minusImg.substring(mn+1):minusImg;");
        jb.append("isLast= (lineImg.src.lastIndexOf(plusKey)+ plusKey.length)==lineImg.src.length || (lineImg.src.lastIndexOf(minusKey)+ minusKey.length)==lineImg.src.length;");
        jb.append("minusImg=isLast?'" + timg.getMinusLast() + "':'" + timg.getMinus() + "';");
        jb.append("plusImg=isLast?'" + timg.getPlusLast() + "':'" + timg.getPlus() + "';");
        jb.append("document.getElementById(id+'_line').src=dpFlag=='none'?minusImg:plusImg;");
        jb.append("document.getElementById(id+'_folder').src=dpFlag=='none'?'" + timg.getFolderOpen() + "':'" + timg.getFolderClosed() + "';");
        jb.append("}</script>");
        return jb.toString();
    }

    private static void insertRoot(StringBuffer sb, TreeImages timg, TreeData tdata) {
        sb.append("<div><img src='").append(timg.getRoot()).append("' align='absmiddle' border='0'>").append(SPACE);
        sb.append(tdata.getRootUrl() != null ? tdata.getRootUrl() : "").append(tdata.getRootName());
        sb.append(tdata.getRootUrl() != null ? "</a>" : "").append("</div>");
    }

    private static void insertBody(String lineMap, Object parentNode, StringBuffer sb, TreeImages timg, TreeData tdata) {
        List<?> ls0 = tdata.getData(parentNode);
        if (ls0 == null || ls0.size() < 1) {
            return;
        }
        int i = 0;
        while (i < ls0.size()) {
            boolean isLast;
            Object node = ls0.get(i);
            boolean bl = isLast = i == ls0.size() - 1;
            if (tdata.isFolder(node)) {
                TreeCreater.insertFloderHead(node, isLast, lineMap, i, sb, timg, tdata);
                TreeCreater.insertBody(isLast ? String.valueOf(lineMap) + "0" : String.valueOf(lineMap) + "1", node, sb, timg, tdata);
                sb.append("</div>");
            } else {
                TreeCreater.insertFile(node, isLast, lineMap, sb, timg, tdata);
            }
            ++i;
        }
    }

    private static void insertFloderHead(Object node, boolean isLast, String lineMap, int index, StringBuffer sb, TreeImages timg, TreeData tdata) {
        String htmlId = String.valueOf(UUID.randomUUID().toString()) + "_" + index + "_" + lineMap;
        sb.append("<div>");
        int i = 0;
        while (i < lineMap.length()) {
            sb.append(lineMap.charAt(i) == '1' ? TreeCreater.getImg(timg.getLine()) : TreeCreater.getImg(timg.getEmpty()));
            ++i;
        }
        boolean isOpen = tdata.isOpenFolder(node);
        sb.append("<IMG STYLE='cursor:pointer;' id='" + htmlId + "_line' SRC='" + (isLast ? (isOpen ? timg.getMinusLast() : timg.getPlusLast()) : (isOpen ? timg.getMinus() : timg.getPlus())) + "' BORDER='0' ALIGN='absmiddle' OnClick=\"" + onClickFunName + "('" + htmlId + "')\">");
        sb.append("<IMG STYLE='cursor:pointer;' id='" + htmlId + "_folder' SRC='" + (isOpen ? timg.getFolderOpen() : timg.getFolderClosed()) + "' BORDER='0' OnClick=\"" + onClickFunName + "('" + htmlId + "')\" ALIGN='absmiddle'/>" + SPACE);
        String url = tdata.getNodeUrl(node);
        sb.append(url != null ? url : "").append(tdata.getNodeName(node)).append(url != null ? "</a>" : "");
        sb.append("</div><div id='" + htmlId + "' style='display:" + (isOpen ? "" : "none") + ";'>");
    }

    private static void insertFile(Object node, boolean isLast, String lineMap, StringBuffer sb, TreeImages timg, TreeData tdata) {
        sb.append("<div>");
        int i = 0;
        while (i < lineMap.length()) {
            sb.append(lineMap.charAt(i) == '1' ? TreeCreater.getImg(timg.getLine()) : TreeCreater.getImg(timg.getEmpty()));
            ++i;
        }
        sb.append("<IMG SRC='" + (isLast ? timg.getFileLineLast() : timg.getFileLine()) + "' BORDER='0' ALIGN='absmiddle'>");
        String img = tdata.getNodeImg(node);
        sb.append("<IMG SRC='" + (img == null ? timg.getDefaultFile() : img) + "' BORDER='0' ALIGN='absmiddle'/>" + SPACE);
        String url = tdata.getNodeUrl(node);
        sb.append(url != null ? url : "").append(tdata.getNodeName(node)).append(url != null ? "</a>" : "");
        sb.append("</div>");
    }

    private static String getImg(String src) {
        return "<img src='" + src + "' border='0' align='absmiddle'>";
    }
}

