/*
 * Decompiled with CFR 0.152.
 */
package code.util.db;

public class Pager {
    private int recordPerPage = 20;
    private int recordCount = 0;
    private int recordCountCurrentPage = 0;
    private int pageCount = 0;
    private int currentPage = 1;

    public Pager() {
    }

    public Pager(int pRecordPerPage, int pCurrentPage) {
        if (pRecordPerPage < 0) {
            throw new IllegalArgumentException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        if (pCurrentPage < 0) {
            throw new IllegalArgumentException("\u5f53\u524d\u9875\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        this.recordPerPage = pRecordPerPage;
        this.currentPage = pCurrentPage;
    }

    public Pager(int pCurrentPage) {
        if (pCurrentPage < 0) {
            throw new IllegalArgumentException("\u5f53\u524d\u9875\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        this.currentPage = pCurrentPage;
    }

    public int getRecordCountCurrentPage() {
        return this.recordCountCurrentPage;
    }

    public void setRecordCountCurrentPage(int pRecordCountCurrentPage) {
        if (pRecordCountCurrentPage < 0) {
            throw new IllegalArgumentException("\u5f53\u524d\u9875\u8bb0\u5f55\u6570\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        this.recordCountCurrentPage = pRecordCountCurrentPage;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        if (recordCount < 0) {
            throw new IllegalArgumentException("\u603b\u8bb0\u5f55\u6570\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        this.recordCount = recordCount;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        if (pageCount < 0) {
            throw new IllegalArgumentException("\u603b\u9875\u6570\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        this.pageCount = pageCount;
    }

    public int getRecordPerPage() {
        return this.recordPerPage;
    }

    public void setRecordPerPage(int pRecordPerPage) {
        if (pRecordPerPage < 0) {
            throw new IllegalArgumentException("\u6bcf\u9875\u7684\u8bb0\u5f55\u6570\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        this.recordPerPage = pRecordPerPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int pCurrentPage) {
        if (pCurrentPage < 0) {
            throw new IllegalArgumentException("\u5f53\u524d\u9875\u4e0d\u5f97\u5c0f\u4e8e0\uff01");
        }
        this.currentPage = pCurrentPage;
    }

    public boolean getHasPre() {
        return this.currentPage > 1;
    }

    public boolean getHasNext() {
        return this.currentPage < this.pageCount;
    }

    public int getPrePage() {
        if (this.getHasPre()) {
            return this.currentPage - 1;
        }
        return 0;
    }

    public int getNextPage() {
        if (this.getHasNext()) {
            return this.currentPage + 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Pager stat : ").append("\u603b\u8bb0\u5f55\u6570 =").append(this.recordCount);
        sb.append(", \u603b\u9875\u6570=").append(this.pageCount);
        sb.append(", \u6bcf\u9875\u8bb0\u5f55\u6570=").append(this.recordPerPage);
        sb.append(", \u5f53\u524d\u9875\u7801=").append(this.currentPage);
        return sb.toString();
    }
}

