/*
 * Decompiled with CFR 0.152.
 */
package code.util.db;

import code.util.db.DBDialect;
import code.util.db.DBDialectDefault;
import code.util.db.DBOperator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtil {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private Connection connection = null;
    private DBDialect dialect = new DBDialectDefault();

    public DBUtil(DataSource dataSource) {
        try {
            this.connection = dataSource.getConnection();
            this.log.debug("DB connection opened.");
        }
        catch (Exception ex) {
            throw new RuntimeException("Get Connection from DataSource error!", ex);
        }
    }

    public DBUtil(Connection connection) {
        this.connection = connection;
        this.log.debug("DB connection opened.");
    }

    public DBUtil(String url, String driver, String user, String pwd) {
        this.connection = DBUtil.openConnection(url, driver, user, pwd);
        this.log.debug("DB connection opened.");
    }

    private static Connection openConnection(String url, String driver, String user, String pwd) {
        try {
            Properties property = new Properties();
            property.put("user", user);
            property.put("password", pwd);
            Driver diver = (Driver)Class.forName(driver).newInstance();
            return diver.connect(url, property);
        }
        catch (Exception e) {
            throw new RuntimeException("Open connection error.", e);
        }
    }

    public void beginTransaction() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            throw new SQLException("Transaction is opened for connection:" + this.connection);
        }
        this.connection.setAutoCommit(false);
        this.log.debug("######### Transaction begin #########");
    }

    public void commit() throws SQLException {
        this.connection.commit();
        this.connection.setAutoCommit(true);
        this.log.debug("********* Transaction commit *********");
    }

    public void rollback() {
        try {
            try {
                this.connection.rollback();
                this.log.debug("&&&&&&&&& Transaction rollback &&&&&&&&&");
            }
            catch (SQLException se) {
                this.log.warn(se.getMessage());
                try {
                    this.connection.setAutoCommit(true);
                }
                catch (SQLException e) {
                    this.log.warn(e.getMessage());
                }
            }
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.log.warn(e.getMessage());
            }
        }
    }

    public DBOperator createOperator() {
        return new DBOperator(this.connection, this.dialect);
    }

    public DBOperator createOperator(String sql) {
        return new DBOperator(this.connection, sql, this.dialect);
    }

    public void close() {
        try {
            this.connection.close();
            if (this.log.isDebugEnabled()) {
                this.log.debug("DB connection closed.");
            }
        }
        catch (SQLException e) {
            this.log.warn("Close DB connection error.", (Object)e.getMessage());
        }
    }

    public void setDialectInstance(DBDialect dialect) {
        this.dialect = dialect;
    }

    public void setDialect(String dbName) {
        String clazz = String.valueOf(DBDialect.class.getName()) + dbName;
        try {
            Object dia = Class.forName(clazz).newInstance();
            this.dialect = (DBDialect)dia;
        }
        catch (Exception ex) {
            this.log.error(String.valueOf(clazz) + " is not a DBDialect class", (Throwable)ex);
        }
    }

    public static void main(String[] as) throws Exception {
        DBUtil.queryTest();
    }

    public static void queryTest() throws SQLException {
        String url = "jdbc:mysql://127.0.0.1:3306/auth?characterEncoding=utf8";
        String clazz = "com.mysql.jdbc.Driver";
        DBUtil dbu = new DBUtil(url, clazz, "root", "root");
        dbu.beginTransaction();
        try {
            try {
                dbu.createOperator("insert into htrans_jnl(local_serial,retcode) values('123','22')").update();
                dbu.createOperator("insert into charge_jnl(car_vin) values('11')").update();
                dbu.createOperator("insert into charge_jnl(car_vin) values('11')").update();
                dbu.commit();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                dbu.rollback();
                dbu.close();
            }
        }
        finally {
            dbu.close();
        }
    }
}

