/*
 * Decompiled with CFR 0.152.
 */
package code.util.db;

import code.util.db.DBDialect;
import code.util.db.DBField;
import code.util.db.Pager;
import code.util.db.QueryResult;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBOperator {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Pattern KEY_PATTERN = Pattern.compile(":\\w+");
    private final Map<String, Object> paramMap = new HashMap<String, Object>();
    private String sql = null;
    private Connection connection = null;
    private Class<?> entryClass = null;
    private final DBDialect dialect;

    DBOperator(Connection connection, DBDialect dialect) {
        this.connection = connection;
        this.dialect = dialect;
    }

    DBOperator(Connection connection, String sql, DBDialect dialect) {
        this.connection = connection;
        this.dialect = dialect;
        this.sql = sql;
    }

    public DBOperator setParameter(String name, Object value) {
        this.paramMap.put(name, value);
        return this;
    }

    public DBOperator setParameter(Map<String, Object> params) {
        if (params != null) {
            this.paramMap.putAll(params);
        }
        return this;
    }

    public DBOperator setEntry(Class<?> clazz) {
        this.entryClass = clazz;
        return this;
    }

    public DBOperator setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public int update() throws SQLException {
        PreparedStatement ps = this.preparedStatement(this.sql);
        int res = ps.executeUpdate();
        ps.close();
        return res;
    }

    public QueryResult query() throws SQLException {
        return this.doQuery(0, 0, this.sql);
    }

    public QueryResult query(int first, int count) throws SQLException {
        return this.doQuery(first, count, this.sql);
    }

    public QueryResult query(Pager pg) throws SQLException {
        int rdCound = this.queryRecordCount();
        int first = (pg.getCurrentPage() - 1) * pg.getRecordPerPage();
        if (first < 0 || rdCound - first < 0) {
            first = 0;
        }
        this.setPagerStat(first, rdCound, pg);
        return this.doQuery(first, pg.getRecordPerPage(), this.sql);
    }

    public Object uniqueQuery() throws SQLException {
        QueryResult res = this.doQuery(0, 1, this.sql);
        return res.getData().size() > 0 ? res.getData().get(0) : null;
    }

    private static String toDBFieldName(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        char[] cs = name.toCharArray();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] >= 'A' && cs[i] <= 'Z' && i != 0) {
                sb.append("_");
            }
            sb.append(cs[i]);
            ++i;
        }
        return sb.toString();
    }

    private Map<String, Field> getFieldsMap() {
        Field[] fds;
        if (this.entryClass == null) {
            return null;
        }
        HashMap<String, Field> mp = new HashMap<String, Field>();
        Field[] fieldArray = fds = this.entryClass.getDeclaredFields();
        int n = fds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fd = fieldArray[n2];
            if (fd.isAnnotationPresent(DBField.class)) {
                String v = fd.getAnnotation(DBField.class).value();
                if (v.equals("auto.resolve.value")) {
                    v = DBOperator.toDBFieldName(fd.getName());
                }
                mp.put(v.toLowerCase(), fd);
            }
            ++n2;
        }
        return mp;
    }

    private QueryResult doQuery(int tFirst, int count, String tSql) throws SQLException {
        DBDialect.SelectSQL ssql = this.dialect.select(tSql, tFirst, count);
        int first = ssql.first;
        PreparedStatement ps = this.preparedStatement(ssql.sql);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rsm = rs.getMetaData();
        String[] cols = new String[rsm.getColumnCount()];
        int i = 0;
        while (i < cols.length) {
            String colName = rsm.getColumnName(i + 1);
            if (colName.equals("")) {
                colName = rsm.getColumnLabel(i + 1);
            }
            cols[i] = colName.toLowerCase();
            ++i;
        }
        Map<String, Field> fdMap = this.getFieldsMap();
        ArrayList<Object> res = new ArrayList<Object>();
        int i2 = 0;
        int n = first + count;
        while ((n == 0 || i2 < n) && rs.next()) {
            if (i2 >= first) {
                res.add(this.getRowValue(rs, cols, fdMap));
            }
            ++i2;
        }
        rs.close();
        ps.close();
        return new QueryResult(res, cols);
    }

    private int queryRecordCount() throws NumberFormatException, SQLException {
        this.checkSQL();
        this.sql = this.sql.trim();
        String tql = this.sql.toLowerCase();
        int fb = tql.indexOf(" order ");
        if (fb != -1) {
            tql = this.sql.substring(0, fb);
        }
        tql = "select count(0) as cnt from (" + tql + ") as z_z";
        return Integer.parseInt("" + this.doQuery(0, 1, tql).getData().get(0));
    }

    private void setPagerStat(int first, int count, Pager pg) {
        pg.setRecordCount(count);
        pg.setRecordCountCurrentPage(pg.getRecordPerPage());
        if (first + pg.getRecordPerPage() > count) {
            pg.setRecordCountCurrentPage(count - first);
        }
        int pages = count / pg.getRecordPerPage();
        if (count % pg.getRecordPerPage() != 0) {
            ++pages;
        }
        pg.setPageCount(pages);
    }

    private Object getRowValue(ResultSet rs, String[] cols, Map<String, Field> fdMap) {
        try {
            if (this.entryClass != null) {
                Object row = this.entryClass.newInstance();
                String[] stringArray = cols;
                int n = cols.length;
                int n2 = 0;
                while (n2 < n) {
                    String colName = stringArray[n2];
                    Field fd = fdMap.get(colName);
                    if (fd == null) {
                        throw new RuntimeException("Not found " + this.entryClass.getName() + " mapping Field for DB column '" + colName + "'");
                    }
                    String mhName = "set" + fd.getName().substring(0, 1).toUpperCase() + (fd.getName().length() > 1 ? fd.getName().substring(1) : "");
                    Method mh = this.entryClass.getMethod(mhName, fd.getType());
                    Object value = rs.getObject(colName);
                    try {
                        mh.invoke(row, value);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Set value \"" + (value != null ? value.getClass() : "null") + "\" to method \"" + mh + "\" error.", ex);
                    }
                    ++n2;
                }
                return row;
            }
            if (cols.length == 1) {
                return rs.getObject(cols[0]);
            }
            Object[] os = new Object[cols.length];
            int j = 0;
            while (j < cols.length) {
                os[j] = rs.getObject(cols[j]);
                ++j;
            }
            return os;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("DB ResultSet convert to JavaBean error.", ex);
        }
    }

    private void checkSQL() {
        if (this.sql == null) {
            throw new RuntimeException("Not set sql parameter.");
        }
    }

    private PreparedStatement preparedStatement(String sqlStr) throws SQLException {
        this.checkSQL();
        String tsql = sqlStr;
        ArrayList<Object> values = new ArrayList<Object>();
        Matcher m = KEY_PATTERN.matcher(sqlStr);
        while (m.find()) {
            String key = m.group(0);
            Object param = this.paramMap.get(key.substring(1));
            tsql = tsql.replace(key, this.getFlags(param));
            this.addValues(values, param);
        }
        StringBuilder debugParams = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("SQL [" + tsql + "]");
            debugParams = new StringBuilder();
        }
        PreparedStatement ps = this.connection.prepareStatement(tsql);
        int i = 0;
        while (i < values.size()) {
            Object tvalue = this.convert(values.get(i));
            if (this.log.isDebugEnabled()) {
                debugParams.append("[").append(tvalue).append("]");
            }
            if (tvalue == null) {
                ps.setNull(i + 1, 0);
            } else {
                ps.setObject(i + 1, tvalue);
            }
            ++i;
        }
        if (this.log.isDebugEnabled() && debugParams.length() > 0) {
            this.log.debug("SQL param " + debugParams);
        }
        return ps;
    }

    private Object convert(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (obj instanceof java.util.Date) {
            return new Date(((java.util.Date)obj).getTime());
        }
        return obj;
    }

    private String getFlags(Object param) {
        if (param == null) {
            return "?";
        }
        int n = 1;
        if (param.getClass().isArray()) {
            n = Array.getLength(param);
        }
        if (param instanceof Collection) {
            n = ((Collection)param).size();
        }
        if (n == 1) {
            return "?";
        }
        StringBuffer sb = new StringBuffer("?");
        int i = 1;
        while (i < n) {
            sb.append(",?");
            ++i;
        }
        return sb.toString();
    }

    private void addValues(List<Object> values, Object param) {
        if (param == null) {
            values.add(null);
            return;
        }
        if (param.getClass().isArray()) {
            int i = 0;
            while (i < Array.getLength(param)) {
                values.add(Array.get(param, i));
                ++i;
            }
            return;
        }
        if (param instanceof Collection) {
            values.addAll((Collection)param);
            return;
        }
        values.add(param);
    }
}

