/*
 * Decompiled with CFR 0.152.
 */
package code.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);

    public static void unzip(File zipFile, File toDir) throws ZipException, IOException {
        ZipUtil.unzip(zipFile, "", toDir);
    }

    public static void unzip(File zipFile, String zipEntryNamePrefix, File toDir) throws ZipException, IOException {
        ZipFile zfile = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> zeEnum = zfile.entries();
        while (zeEnum.hasMoreElements()) {
            ZipEntry ze = zeEnum.nextElement();
            if (!ze.getName().startsWith(zipEntryNamePrefix)) continue;
            ZipUtil.unzip(toDir, zfile, ze);
        }
    }

    private static void unzip(File toDir, ZipFile zfile, ZipEntry zipEntry) throws IOException {
        File toFile = new File(String.valueOf(toDir.getPath()) + "/" + zipEntry.getName());
        log.debug("[unzip] " + zipEntry.getName() + " --> " + toFile.getPath());
        if (zipEntry.isDirectory()) {
            toFile.mkdirs();
            return;
        }
        toFile.getParentFile().mkdirs();
        InputStream is = zfile.getInputStream(zipEntry);
        FileOutputStream fos = new FileOutputStream(toFile);
        byte[] buf = new byte[10240];
        int n = -1;
        while ((n = is.read(buf)) != -1) {
            fos.write(buf, 0, n);
        }
        fos.close();
        is.close();
    }

    public static void main(String[] args) throws ZipException, IOException {
        File zf = new File("D:/zhuwei/startup/project/code/example/WEB-INF/lib/code.jar");
        File toDir = new File("d:/temp/uuu");
        ZipUtil.unzip(zf, toDir);
    }
}

