/*
 * Decompiled with CFR 0.152.
 */
package code.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VarUtil {
    private static Pattern varPattern = Pattern.compile("\\{[^\\}]+\\}");
    private static HashMap<String, Set<String>> timeStrMap = new HashMap();

    public static String getTimeStr(String str) {
        Set<String> vars = timeStrMap.get(str);
        if (vars == null) {
            vars = VarUtil.getVars(str);
            timeStrMap.put(str, vars);
        }
        Date now = new Date();
        for (String v : vars) {
            SimpleDateFormat sf = new SimpleDateFormat(VarUtil.getKey(v));
            str = VarUtil.setVar(str, v, sf.format(now));
        }
        return str;
    }

    public static String getKey(String varName) {
        return varName.substring(1, varName.length() - 1);
    }

    public static Set<String> getVars(String str) {
        HashSet<String> set = new HashSet<String>();
        Matcher m = varPattern.matcher(str);
        while (m.find()) {
            set.add(m.group(0));
        }
        return set;
    }

    public static String setVar(String sourceStr, String varName, String value) {
        return sourceStr.replaceAll("\\{" + VarUtil.getKey(varName) + "\\}", value);
    }
}

