/*
 * Decompiled with CFR 0.152.
 */
package code.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);
    private static final String LINE = System.getProperty("line.separator");

    private static String getFiles(String parentPath, File f, Filter ... filters) {
        String tpath = String.valueOf(parentPath) + "/" + f.getName();
        if (f.isFile()) {
            if (filters != null) {
                Filter[] filterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    Filter ft = filterArray[n2];
                    if (ft.isFilter(tpath)) {
                        return null;
                    }
                    ++n2;
                }
            }
            return tpath;
        }
        File[] ff = f.listFiles();
        if (ff != null && ff.length > 0) {
            StringBuffer sb = new StringBuffer();
            File[] fileArray = ff;
            int n = ff.length;
            int n3 = 0;
            while (n3 < n) {
                File tf = fileArray[n3];
                String ts = ResourceUtil.getFiles(tpath, tf, filters);
                if (ts != null) {
                    sb.append(sb.length() == 0 ? "" : LINE).append(ts);
                }
                ++n3;
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        return null;
    }

    public static void makeResourceIndexFile(String rootPath, String indexFilePath, Filter ... filters) throws IOException {
        File root = new File(rootPath);
        File indexFile = new File(indexFilePath);
        indexFile.getParentFile().mkdirs();
        String txt = null;
        if (root.exists() && root.isDirectory()) {
            txt = ResourceUtil.getFiles("", root, filters);
        }
        txt = txt == null ? "" : txt;
        txt = "/" + root.getName() + LINE + txt;
        FileOutputStream fos = new FileOutputStream(indexFile);
        fos.write(txt.getBytes());
        fos.close();
        log.info("Resource index file make success!");
    }

    public static void releaseResource(String toDirPath, InputStream indexFile) throws IOException {
        File toDir = new File(toDirPath);
        toDir.mkdirs();
        BufferedReader br = new BufferedReader(new InputStreamReader(indexFile));
        String l = null;
        String rootDir = null;
        while ((l = br.readLine()) != null) {
            if (rootDir == null) {
                rootDir = l;
                continue;
            }
            InputStream fis = ResourceUtil.getResourceFileInputStream(l);
            if (fis == null) continue;
            File tf = new File(String.valueOf(toDir.getPath()) + l.substring(rootDir.length()));
            tf.getParentFile().mkdirs();
            byte[] buff = new byte[10240];
            FileOutputStream fos = new FileOutputStream(tf);
            int n = 0;
            while ((n = fis.read(buff)) != -1) {
                fos.write(buff, 0, n);
            }
            fos.close();
            fis.close();
            log.info("Release resource file: " + tf.getPath());
        }
    }

    public static InputStream getResourceFileInputStream(String classpath) {
        InputStream is = ResourceUtil.class.getResourceAsStream(classpath);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpath);
        }
        if (is == null) {
            log.error("No found resource file: " + classpath);
        }
        return is;
    }

    public static void main(String[] as) throws IOException {
        Filter ft1 = new Filter(){

            @Override
            public boolean isFilter(String name) {
                return name.indexOf("/src/code/") == -1 || name.indexOf("SVN") != -1;
            }
        };
        String dir = "D:/zhuwei/jee/code";
        if (as != null && as.length > 0) {
            dir = as[0];
        }
        ResourceUtil.makeResourceIndexFile(String.valueOf(dir) + "/web", String.valueOf(dir) + "/temp/resource.txt", ft1);
    }

    public static abstract class Filter {
        public abstract boolean isFilter(String var1);
    }
}

