/*
 * Decompiled with CFR 0.152.
 */
package code.tree;

import code.tree.PatternClickMatcher;
import code.util.VarUtil;
import code.web.CodeFilter;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class RequestParamPatternClickMatcher
extends PatternClickMatcher {
    private String varKey = null;

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
        Set<String> vars = VarUtil.getVars(pattern);
        if (vars.size() != 1) {
            throw new RuntimeException("RequestParamWhere\u7684template\u53c2\u6570\u53ea\u652f\u6301\u5355\u4e2a{key}\u683c\u5f0f\uff0c\u9519\u8bef\u7684template=" + pattern);
        }
        this.varKey = vars.iterator().next();
    }

    @Override
    protected Pattern getRegex() {
        HttpServletRequest request = CodeFilter.getHttpServletRequest();
        String value = request.getParameter(VarUtil.getKey(this.varKey));
        if (value != null && !(value = value.trim()).equals("")) {
            String tpattern = VarUtil.setVar(this.pattern, this.varKey, value);
            return Pattern.compile(tpattern);
        }
        return null;
    }
}

