/*
 * Decompiled with CFR 0.152.
 */
package code.table;

import code.util.db.Pager;
import code.web.CodeFilter;
import javax.servlet.http.HttpServletRequest;

public class CodeTablePage {
    private static final long serialVersionUID = 1663006973594688872L;
    private static final String CURRENT_PAGE = "currentPage";
    private final String toPageJs = "toPage";
    private final String defaultFun = "default_query()";
    private final String fun = "default_query()";
    private final String selectId = "current_page_id";

    public String generateJs() {
        return "<script>" + this.getJs() + "</script>";
    }

    public String generateHtml(Pager pv) {
        StringBuffer sb = new StringBuffer();
        if (pv == null) {
            return "";
        }
        sb.append("\u5171").append(pv.getRecordCount()).append("\u6761&nbsp;");
        sb.append("\u6bcf\u9875").append(pv.getRecordPerPage()).append("\u6761&nbsp;");
        sb.append("\u7b2c").append(pv.getCurrentPage()).append("/").append(pv.getPageCount()).append("\u9875&nbsp;");
        if (pv.getCurrentPage() > 1) {
            sb.append("<a href=\"javascript:").append("toPage").append("(");
            sb.append(pv.getCurrentPage() - 1).append(")").append("\">\u4e0a\u9875</a>&nbsp;");
        }
        if (pv.getCurrentPage() < pv.getPageCount()) {
            sb.append("<a href=\"javascript:").append("toPage").append("(");
            sb.append(pv.getCurrentPage() + 1).append(")").append("\">\u4e0b\u9875</a>&nbsp;");
        }
        sb.append(this.makeSelect(pv));
        return sb.toString();
    }

    private String getJs() {
        return "function toPage(page){document.getElementById(\"current_page_id\").selectedIndex=page-1; default_query();}";
    }

    public static Pager createPager() {
        HttpServletRequest req = CodeFilter.getHttpServletRequest();
        Pager pv = new Pager(10, 1);
        if (req.getParameter(CURRENT_PAGE) != null) {
            pv.setCurrentPage(Integer.parseInt(req.getParameter(CURRENT_PAGE)));
        }
        return pv;
    }

    protected String makeSelect(Pager pv) {
        StringBuffer result = new StringBuffer();
        result.append("<select onchange=\"default_query()\" name=\"").append(CURRENT_PAGE).append("\" id=\"").append("current_page_id").append("\">");
        int i = 0;
        while (i < pv.getPageCount()) {
            result.append("<option value=\"").append(i + 1).append("\"");
            if (pv.getCurrentPage() == i + 1) {
                result.append(" selected");
            }
            result.append(">").append(i + 1).append("</option>");
            ++i;
        }
        result.append("</select>");
        return result.toString();
    }
}

