/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.AbsWhere;
import code.Where;
import code.util.db.DBOperator;
import code.web.CodeFilter;
import java.util.HashMap;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;

public class RequestParamWhere
extends AbsWhere {
    private String paramName = null;
    private Class<?> valueClass = String.class;
    private String template;

    public void setValueClass(String valueClazzName) {
        try {
            this.valueClass = Class.forName(valueClazzName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown valueClass [" + valueClazzName + "]", e);
        }
    }

    public void setTemplate(String template) {
        Matcher m = DBOperator.KEY_PATTERN.matcher(template);
        if (!m.find()) {
            throw new IllegalArgumentException("Not found ':xxx' string.");
        }
        this.paramName = m.group(0).substring(1);
        this.template = template;
    }

    private Object convertParamObject(String value) {
        try {
            return this.valueClass.getConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Convert [" + value + "] to " + this.valueClass + " instance error.", e);
        }
    }

    @Override
    public Where.WhereExpression getExpression() {
        HttpServletRequest request = CodeFilter.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        String value = request.getParameter(this.paramName);
        if (value != null && !(value = value.trim()).equals("")) {
            value = this.reqParamSpecialProcess(value);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
            paramMap.put(this.paramName, this.convertParamObject(value));
            return new Where.WhereExpression(this.template, paramMap);
        }
        return null;
    }

    protected String reqParamSpecialProcess(String value) {
        return value;
    }
}

