/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.Where;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    protected String name = "\u672a\u8bbe\u7f6e";
    protected String sql = null;
    protected String orderBy = null;
    protected String idField = null;
    protected String nameField = null;
    protected List<Where> wheres = null;
    private String hasWhereSql = null;

    public List<Where> getWheres() {
        return this.wheres;
    }

    public void setWheres(List<Where> wheres) {
        if (this.wheres != null) {
            this.wheres.addAll(wheres);
        }
    }

    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
        this.hasWhereSql = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    private String getHasWhereSql() {
        if (this.hasWhereSql == null) {
            String tsql = this.sql.toLowerCase();
            while (tsql.indexOf("(") != -1) {
                tsql = tsql.replaceAll("\\([^\\(]*?\\)", "");
            }
            boolean hasWhere = Pattern.compile("\\swhere\\s").matcher(tsql).find();
            log.debug(String.valueOf(this.name) + " Sql has 'where' = " + hasWhere);
            this.hasWhereSql = hasWhere ? this.sql : String.valueOf(this.sql) + " where 1=1";
        }
        return this.hasWhereSql;
    }

    public SqlData generateSql() {
        StringBuffer res = new StringBuffer(this.getHasWhereSql());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (this.wheres != null) {
            for (Where w : this.wheres) {
                Where.WhereExpression we = w.getExpression();
                if (we == null) continue;
                res.append(w.isAnd() ? " and " : " or ").append(we.expression);
                if (we.paramMap == null) continue;
                paramMap.putAll(we.paramMap);
            }
        }
        if (this.orderBy != null) {
            res.append(" order by ").append(this.orderBy);
        }
        log.debug(String.valueOf(this.name) + " Generate Sql [" + res + "]");
        return new SqlData(res.toString(), paramMap);
    }

    public static class SqlData {
        public final String sql;
        public final Map<String, Object> paramMap;

        public SqlData(String sql, Map<String, Object> paramMap) {
            this.sql = sql;
            this.paramMap = paramMap;
        }
    }
}

