/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.W3CAddressingConstants;
import com.sun.xml.internal.ws.api.server.DocumentAddressResolver;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.server.SDDocumentImpl;
import com.sun.xml.internal.ws.server.ServiceDefinitionImpl;
import com.sun.xml.internal.ws.server.WSEndpointImpl;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WSDLPatcher
extends XMLStreamReaderToXMLStreamWriter {
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.wsdl.patcher");
    private final WSEndpointImpl<?> endpoint;
    private final SDDocumentImpl current;
    private final DocumentAddressResolver resolver;
    private final PortAddressResolver portAddressResolver;
    private String targetNamespace;
    private QName serviceName;
    private QName portName;
    private EPR_ADDRESS_STATE eprAddressState = EPR_ADDRESS_STATE.OUT;

    public WSDLPatcher(WSEndpointImpl<?> wSEndpointImpl, SDDocumentImpl sDDocumentImpl, PortAddressResolver portAddressResolver, DocumentAddressResolver documentAddressResolver) {
        this.endpoint = wSEndpointImpl;
        this.current = sDDocumentImpl;
        this.portAddressResolver = portAddressResolver;
        this.resolver = documentAddressResolver;
    }

    @Override
    protected void handleAttribute(int n) throws XMLStreamException {
        String string;
        QName qName = this.in.getName();
        String string2 = this.in.getAttributeLocalName(n);
        if (qName.equals(SCHEMA_INCLUDE_QNAME) && string2.equals("schemaLocation") || qName.equals(SCHEMA_IMPORT_QNAME) && string2.equals("schemaLocation") || qName.equals(WSDLConstants.QNAME_IMPORT) && string2.equals("location")) {
            String string3 = this.in.getAttributeValue(n);
            String string4 = this.getPatchedImportLocation(string3);
            if (string4 == null) {
                return;
            }
            logger.fine("Fixing the relative location:" + string3 + " with absolute location:" + string4);
            this.writeAttribute(n, string4);
            return;
        }
        if ((qName.equals(WSDLConstants.NS_SOAP_BINDING_ADDRESS) || qName.equals(WSDLConstants.NS_SOAP12_BINDING_ADDRESS)) && string2.equals("location") && (string = this.getAddressLocation()) != null) {
            logger.fine("Fixing service:" + this.serviceName + " port:" + this.portName + " address with " + string);
            this.writeAttribute(n, string);
            return;
        }
        super.handleAttribute(n);
    }

    private void writeAttribute(int n, String string) throws XMLStreamException {
        String string2 = this.in.getAttributeNamespace(n);
        if (string2 != null) {
            this.out.writeAttribute(this.in.getAttributePrefix(n), string2, this.in.getAttributeLocalName(n), string);
        } else {
            this.out.writeAttribute(this.in.getAttributeLocalName(n), string);
        }
    }

    @Override
    protected void handleStartElement() throws XMLStreamException {
        QName qName = this.in.getName();
        if (qName.equals(WSDLConstants.QNAME_DEFINITIONS)) {
            String string = this.in.getAttributeValue(null, "targetNamespace");
            if (string != null) {
                this.targetNamespace = string;
            }
        } else if (qName.equals(WSDLConstants.QNAME_SERVICE)) {
            String string = this.in.getAttributeValue(null, "name");
            if (string != null) {
                this.serviceName = new QName(this.targetNamespace, string);
            }
        } else if (qName.equals(WSDLConstants.QNAME_PORT)) {
            String string = this.in.getAttributeValue(null, "name");
            if (string != null) {
                this.portName = new QName(this.targetNamespace, string);
            }
        } else if (qName.equals(W3CAddressingConstants.WSA_ADDRESS_QNAME)) {
            this.eprAddressState = EPR_ADDRESS_STATE.IN;
        }
        super.handleStartElement();
    }

    @Override
    protected void handleEndElement() throws XMLStreamException {
        QName qName = this.in.getName();
        if (qName.equals(W3CAddressingConstants.WSA_ADDRESS_QNAME)) {
            this.eprAddressState = EPR_ADDRESS_STATE.OUT;
        }
        super.handleEndElement();
    }

    @Override
    protected void handleCharacters() throws XMLStreamException {
        String string;
        if (this.eprAddressState == EPR_ADDRESS_STATE.IN && (string = this.getAddressLocation()) != null) {
            logger.fine("Fixing EPR Address for service:" + this.serviceName + " port:" + this.portName + " address with " + string);
            this.out.writeCharacters(string);
            this.eprAddressState = EPR_ADDRESS_STATE.DONE;
        }
        if (this.eprAddressState != EPR_ADDRESS_STATE.DONE) {
            super.handleCharacters();
        }
    }

    @Nullable
    private String getPatchedImportLocation(String string) {
        try {
            ServiceDefinitionImpl serviceDefinitionImpl = this.endpoint.getServiceDefinition();
            assert (serviceDefinitionImpl != null);
            URL uRL = new URL(this.current.getURL(), string);
            SDDocument sDDocument = serviceDefinitionImpl.getBySystemId(uRL);
            if (sDDocument == null) {
                return string;
            }
            return this.resolver.getRelativeAddressFor(this.current, sDDocument);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String getAddressLocation() {
        return this.portAddressResolver == null || this.portName == null ? null : this.portAddressResolver.getAddressFor(this.serviceName, this.portName.getLocalPart());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EPR_ADDRESS_STATE {
        IN,
        OUT,
        DONE;

    }
}

