// Created by Gino Moreci, Ocotober 23, 2017
using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace Encrypt_Program{
	class Encrypt{
		[DllImport("kernel32.dll")]
		static extern IntPtr GetConsoleWindow();

		[DllImport("user32.dll")]
		static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);
		
		static void form(){
			Form myForm = new Form();
			myForm.MaximizeBox = false;
			myForm.MinimizeBox = false;
			myForm.FormBorderStyle = FormBorderStyle.FixedDialog;
			myForm.Text = "Gino's Encryptor";
			myForm.StartPosition = FormStartPosition.CenterScreen;
			myForm.Width = 327;
			myForm.Height = 300;
			
			Button encryptButton = new Button();
			encryptButton.Text = "Encrypt";
			encryptButton.Left = 57;
			encryptButton.Top = 220;
			myForm.Controls.Add(encryptButton);
			
			Button decryptButton = new Button();
			decryptButton.Text = "Decrypt";
			decryptButton.Left = 197;
			decryptButton.Top = 220;
			myForm.Controls.Add(decryptButton);
			
			Button messageClear = new Button();
			messageClear.Text = "Clear";
			messageClear.Left = 275;
			messageClear.Top = 48;
			messageClear.Width = 40;
			messageClear.Height = 25;
			myForm.Controls.Add(messageClear);
			
			Button keyClear = new Button();
			keyClear.Text = "Clear";
			keyClear.Left = 275;
			keyClear.Top = 97;
			keyClear.Width = 40;
			keyClear.Height = 25;
			myForm.Controls.Add(keyClear);
			
			TextBox messageBox = new TextBox();
			messageBox.Left = 70;
			messageBox.Top = 50;
			messageBox.Width = 200;
			myForm.Controls.Add(messageBox);
			
			TextBox keyBox = new TextBox();
			keyBox.Left = 70;
			keyBox.Top = 100;
			keyBox.Width = 200;
			myForm.Controls.Add(keyBox);
			
			Label messageText = new Label();
			messageText.Width = 55;
			messageText.Text = "Message: ";
			messageText.Left = 10;
			messageText.Top = 52;
			myForm.Controls.Add(messageText);
			
			Label keyText = new Label();
			keyText.Text = "Key: ";
			keyText.Width = 27;
			keyText.Left = 23;
			keyText.Top = 102;
			myForm.Controls.Add(keyText);
			
			Label copyTo = new Label();
			copyTo.Text = "Copy (encrypted) message to clipboard?";
			copyTo.Width = 250;
			copyTo.Left = 60;
			copyTo.Top = 143;
			myForm.Controls.Add(copyTo);
			
			Label copyFrom = new Label();
			copyFrom.Text = "Paste clipboard into message box?";
			copyFrom.Width = 250;
			copyFrom.Left = 60;
			copyFrom.Top = 179;
			myForm.Controls.Add(copyFrom);
			
			CheckBox copyBox = new CheckBox();
			copyBox.Left = 35;
			copyBox.Top = 140;
			myForm.Controls.Add(copyBox);
			
			CheckBox pasteBox = new CheckBox();
			pasteBox.Left = 35;
			pasteBox.Top = 175;
			myForm.Controls.Add(pasteBox);
			
			encryptButton.Click += (sender,e) => 
			{ if (messageBox.Text == "" || keyBox.Text == ""){
				MessageBox.Show("Please enter a message and key.");
			}
			else{
				messageBox.Text = encrypt(messageBox.Text, keyBox.Text);
				if (copyBox.Checked){
				Clipboard.SetText(messageBox.Text);
					};
				};
			};
			
			decryptButton.Click += (sender,e) => 
			{if (keyBox.Text == "" || (messageBox.Text == "" && !pasteBox.Checked)){
				MessageBox.Show("Please enter a message and key.");
			}
			else{
				if (pasteBox.Checked && messageBox.Text == ""){
				messageBox.Text = decrypt(Clipboard.GetText(),keyBox.Text);
					} 
				else {messageBox.Text = (decrypt(messageBox.Text,keyBox.Text));}
				};
			};
			
			messageClear.Click += (sender, e) => {messageBox.Text = "";};
			keyClear.Click += (sender, e) => {keyBox.Text = "";};
			/*pasteBox.Click += (sender, e) => {
				if (!pasteBox.Checked){
				messageBox.Text = "";
					}
				else{
					messageBox.Text = Clipboard.GetText();}
			};*/
			myForm.ShowDialog();
		}

		[STAThread]
		static void Main(string[] args){
			var handle = GetConsoleWindow();
			ShowWindow(handle,0);
			form();
		}
		
		static string changePhrase(string input, string key, int modifier){
			string alphabet = "A0B1c2D3e4F5g6H7i8J9k!L@m#N$o%P^q&R*s(T)u-V_w=X+y|Z]a[b{C}d;E:f'G,hI<j>K.l/M?n O`p~QrStUvWxYz";
			//Adds additional spaces to ensure that the amount of characters in the message is divisible by the amount of characters in the key (should have been done during encryption process).
			while (input.Length % key.Length != 0){
			input+=" ";
			}
			//Changes each character of the message and stores it in an array.
			char[] output = new char[input.Length];
			for (int i = 0; i < (key.Length); i++ ){
				for (int j = 0; j < (input.Length/key.Length); j++){
				output[j*key.Length+i]= alphabet[absolutemod(alphabet.IndexOf(input[j*key.Length+i])+(modifier * alphabet.IndexOf(key[i])),(alphabet.Length))];
				}
			}
			//Calculates the remaining "spaces" at the end of the message.
			int count = output.Length - 1;
			while (true){
				if (output[count] == ' '){
					count-=1;
					}
				else {break;}
			}
			//Converts the array of characters into a string without the additional spaces (originally added when encrypting the message).
			string finalOut2 = "";
			int count2 = 0;
			foreach(char character in output){
				if (count2 <= count){
				finalOut2+=character;
				count2+=1;
					}
				else{break;}
			}
			return(finalOut2);		

		}

		static string encrypt(string input, string key){
			return(changePhrase(input,key,1));
			}
			
		static string decrypt(string input, string key){
			return(changePhrase(input,key,-1));
		}

		//Allows negative indecies. Ex: absolutemod(-3,11) => 8, so "some string"[8] == "some string"[absolutemod(-3,11)] where -3 is the negative index.
		static int absolutemod(int integer, int length){
			if(integer < 0){
				return((length + integer)%length);
			}
			return(integer%length);
		}
	}
}