﻿/// <reference path="../common/common.js" />

!function () {
    var $ = fly;
    window.indexPath = '';

    fly.box.IndexBase = $.Class({
        constructor: function () {
            this.createMembers();
            $.base.setContentFrame(this.contentFrame[0]);
            this.bindEvents();
            this.getLoginInfo();
            this.getMessage();
        },
        getMessage: function () {
            var get = function () {
                var last = indexPage.newWorks ? indexPage.newWorks[0] : null;
                $.post($.box.ajaxUrl('Work', 'MessageRemind'), {
                    lastId: last ? last.id : null,
                    lastTime: (last ? last.time : null)
                }, function (res) {
                    if (res.success && res.data && res.data != "NOCHANGE") {
                        indexPage.showMessage(res.data);
                    }
                    setTimeout(get, 60000);
                })
            }
            setTimeout(get, 10000)
        },
        showMessage: function (info) {
            //有消息，且最后的消息和上一次提醒的不一样
            this.newWorks = info.works
            this.showWorksInTop(info.works);
            if (info.counts) {
                var count = 0;
                var htmls = [];

                $.each(info.counts, function (c, t) {
                    count += c;
                    if (c) {
                        htmls.push('<b style="color:red">{0}</b> 个{1}'.format(c, t));
                    }
                })

                if (count == 0)//没有或者全是公告
                    return;

                var html = htmls.length == 1 ? "你有 " + htmls[0] + "待处理" : "你有 <b style='color:red'>{0}</b> 个事务待处理：<ul><li>{1}</li></ul>".format(count, htmls.join('</li><li>'))
                html += "<a href='common/list.htm?m=oa&list=inbox' target=f class=submit-button onclick='$.common.showMessage()' style='margin-left:80px'>去看看 ➽</a>";
                $.common.showMessage(html, false, false);

                $.box.postMessage({ type: 'message', count: count });
            }
        },
        showWorkInTop: function (work) {
            var old = this.topMsgBox.children();
            old.animate({ left: -500 }, 200)
            clearTimeout(indexPage.showWorkInTopHandle2);
            indexPage.showWorkInTopHandle2 = setTimeout(function () {
                old.remove();
                var newA = $('<a style="position:relative;display:none" href="{1}" target=f onclick="$.common.showMessage()" >{title}{0}<a/>'.format(work.type == "事务" ? "" : "(" + work.type + ")", work.url, work));
                indexPage.topMsgBox.append(newA);
                newA.fadeIn();
            }, 210)
        },
        showWorksInTop: function (works) {
            if (!works.length)
                return this.topMsgBox.html('')

            var index = 0;
            var toggle = function () {
                indexPage.showWorkInTop(works[index])
                index++;
                if (index >= works.length)
                    index = 0;
                clearTimeout(indexPage.showWorkInTopHandle);
                indexPage.showWorkInTopHandle = setTimeout(toggle, 5000);
            }
            toggle();
        },
        loginInfo: { folderMenus: {} },
        getLoginInfo: function () {
            $.base.getUserContext(function () {
                indexPage.init(window.userContext);
                indexPage.afterInit();
            });
        },
        afterInit: function () {
            if ($.box.isPC && window.userContext.space) {
                evalPC('loginSpace(args)', window.userContext.space)
            }
        },
        bindEvents: function () {
            var me = this;
            this.searchForm.submit(function () {
                search(me.searchBox.value());
                return false;
            });
        },
        logout: function () {
            $.post($.box.ajaxUrl('sys', 'logout'), function (result) {
                if (result.success) {
                    window.open(result.data || $.box.getLoginUrl(), '_top');
                }
                else {
                    $.alert(result.msg)
                }
            })
        },
        showSpaceSize: function () {
            var space = this.loginInfo.space;
            var scale = space.used * 100 / space.size;
            if (scale > 0 && scale < 1)
                scale = 1
            $('#space-size-pro div').width(scale + '%')
            $('#space-size').html('{0} / {1}'.format($.sizeFormat(space.used), $.sizeFormat(space.size)))
            $('#space-size').parent().attr('title', '空间总大小{0}，已使用{1}。'.format($.sizeFormat(space.size), $.sizeFormat(space.used)))
        }
    });

    window.search = function (key) {
        try {
            indexPage.contentFrame[0].contentWindow.search(key);
        } catch (e) { }
    }
} ()

