﻿/// <reference path="../../fly/fly.js" />

!function () {
    var $ = fly;
    $.ui.Menu = $.Class({
        openCss: 'f-open',
        toggleButtonCss: 'f-menu-toggle',
        constructor: function (config) {
            config && $.extend(this, config);
            this.createMembers()
            this.bindEvents()
        },
        createMembers: function () {
            this.el = $(this.el);
            this.container = $(this.container || this.el.parent());
            this.toggleButton = $(this.toggleButton)
            if (!this.toggleButton.length)
                this.toggleButton = this.container.$('.' + this.toggleButtonCss)
        },
        toggle: function () {
            this.container.toggleClass(this.openCss);
        },
        hide: function () {
            this.container.removeClass(this.openCss);
        },
        show: function () {
            this.container.addClass(this.openCss);
        },
        bindEvents: function () {
            this.toggleButton.click(this.toggle, this)
            this.el.on('out_mousedown', this.hide, this);
            this.el.mouseup(this.hide, this);
        }
    })

    $.ui.Menu.applyAll = function (selecter) {
        $(selecter || '.f-menu').each(function () {
            this.flyMenu = new $.ui.Menu({ el: this })
        })
    }
} ()