/*
	Fly.Box-2.1.2  Fly.Box-2.2.1
*/



SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO
BEGIN TRANSACTION
GO
PRINT N'Dropping constraints from [dbo].[fBox_SMS]'
GO
ALTER TABLE [dbo].[fBox_SMS] DROP CONSTRAINT [PK_fBox_SMS]
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Altering [dbo].[fBox_GetFileParents]'
GO



-- =============================================
-- Author:		Kuiyou
-- Create date: 2012-11-9 3:50
-- Description:	ѯϼĿ¼Id
-- ѯ p.Level ʾϲļԽС
-- =============================================
ALTER FUNCTION [dbo].[fBox_GetFileParents] 
(
	@spaceFileId varchar(36),
	@includeRoot bit
)
RETURNS TABLE 
AS
RETURN 
(
	
	  WITH temp(Id,ParentId,Level) AS(
			SELECT Id,ParentId,Level=0 FROM fBox_SpaceFile WHERE id=@spaceFileId
			UNION ALL
			SELECT p.Id,p.ParentId,Level=t.Level-1 FROM fBox_SpaceFile p JOIN temp t 
				ON p.Id=t.ParentId 
				AND (@includeRoot=1 OR p.ParentId IS NOT NULL)
		)
		SELECT *,LEVEL-(SELECT MIN(LEVEL) FROM temp) as LevelPlus FROM temp 
)




GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Altering [dbo].[fly_User]'
GO
ALTER TABLE [dbo].[fly_User] ADD
[Type] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
ALTER TABLE [dbo].[fly_User] ALTER COLUMN [Sex] [nvarchar] (4) COLLATE Chinese_PRC_CI_AS NOT NULL
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Altering [dbo].[fly_Department]'
GO
ALTER TABLE [dbo].[fly_Department] ADD
[Type] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[IsShow] [int] NOT NULL CONSTRAINT [DF_fly_Department_IsShow] DEFAULT ((1))
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Altering [dbo].[fBox_CheckSpaceFileUserACL]'
GO

-- =============================================
-- Author:		Ѱ
-- Create date: 2014-6-24 
-- Description:	ûļȨ
-- ֵ ǷȨ
-- =============================================
ALTER FUNCTION [dbo].[fBox_CheckSpaceFileUserACL]
(
	@spaceFileId VARCHAR(36),
	@userId	VARCHAR(36),
	@checkAcl INT
)
RETURNS BIT
AS
BEGIN
/*
declare @spaceFileId VARCHAR(36)
declare 	@userId	VARCHAR(36)
set @spaceFileId='d0416eb3-3205-4d00-a343-be7a4009ad01'
set @userId='20000000-0000-0000-0000-000000000001'
select dbo.[fBox_CheckSpaceFileUserACL]('d0bb57d1-0fc8-4e6b-b3aa-1a1453291cc9','20000000-0000-0000-0000-000000000001',2)
*/

	DECLARE @acl INT 
	
	--ԼļȨ
	IF(EXISTS(SELECT 1 FROM fBox_SpaceFile WHERE Id=@spaceFileId AND UserId=@userId))
		RETURN 1
	
	SELECT TOP 1 @acl=ACL 
	FROM fBox_SpaceFileUserAuth a 
		JOIN fBox_GetFileParents(@spaceFileId,1) pf
		ON a.SpaceFileId=pf.Id
		WHERE a.UserId=@userId 
	
	--SELECT @acl
	--ûȨޣüⲿźûȨ	
	IF(@acl IS NOT NULL) BEGIN
		return 5;
		IF( (@acl & @checkAcl)=@checkAcl)
			RETURN 1;
		ELSE 
			RETURN 0;
	END
	
	SET @acl=null;

	--˲Ȩޣҽֹü
	SELECT TOP 1 @acl=ACL FROM fBox_SpaceFileDepartmentAuth a 
		JOIN fBox_GetFileParents(@spaceFileId,1) pf
		ON a.SpaceFileId=pf.Id
		WHERE a.DepartmentId=(SELECT DepartmentId FROM dbo.fly_User u WHERE u.Id=@userId)

	IF (@acl IS NOT NULL AND (@acl & @checkAcl)<>@checkAcl) BEGIN
		RETURN 0;
	END


	--һɫȨޣȨ
	IF(EXISTS(
		SELECT TOP 1 ACL FROM (
			SELECT ACL=(
					CASE WHEN ACL IS NULL THEN 
						CASE WHEN (SELECT TOP 1 IsManager FROM fly_Role WHERE Id=ra.RoleId)=1 
							THEN dbo.fBox_FileFullACL()
						ELSE 
							dbo.fBox_FileBaseACL() 
						END
					ELSE ACL END)
				FROM(
					SELECT 
					RoleId,
					ACL=(SELECT TOP 1 ACL FROM fBox_SpaceFileRoleAuth a 
						JOIN fBox_GetFileParents(@spaceFileId,1) pf
						ON a.SpaceFileId=pf.Id
						WHERE a.RoleId=ur.RoleId)
					FROM fly_UserRole ur WHERE UserId=@userId
				) ra
		)ra2
		WHERE (ACL &@checkAcl)=@checkAcl
	))
		RETURN 1
	ELSE
		RETURN 0



	RETURN 0
END

GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_SubjectRateItem]'
GO
CREATE TABLE [dbo].[fEdu_SubjectRateItem]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[RateId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[StartScore] [int] NULL,
[EndScore] [int] NULL,
[Expression] [varchar] (500) COLLATE Chinese_PRC_CI_AS NULL,
[Flag] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL,
[Sort] [int] NOT NULL CONSTRAINT [DF_fEdu_SubjectRateItem_Sort] DEFAULT ((0))
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_SubjectRateItem] on [dbo].[fEdu_SubjectRateItem]'
GO
ALTER TABLE [dbo].[fEdu_SubjectRateItem] ADD CONSTRAINT [PK_fEdu_SubjectRateItem] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fEdu_SubjectRateItem] on [dbo].[fEdu_SubjectRateItem]'
GO
CREATE NONCLUSTERED INDEX [IX_fEdu_SubjectRateItem] ON [dbo].[fEdu_SubjectRateItem] ([RateId], [StartScore])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Student]'
GO
CREATE TABLE [dbo].[fEdu_Student]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[OrgId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NULL,
[Name] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Sex] [varchar] (10) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Phone] [varchar] (30) COLLATE Chinese_PRC_CI_AS NULL,
[Birthday] [datetime] NULL,
[Hometown] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[Nation] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[IdCard] [varchar] (30) COLLATE Chinese_PRC_CI_AS NULL,
[StateOfHealth] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[PoliticalAffiliation] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[AccountKind] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[BornArea] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[OwnerArea] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL,
[StudyingWays] [nvarchar] (10) COLLATE Chinese_PRC_CI_AS NULL,
[Address] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL,
[MailingAddress] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL,
[HomeAddress] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL,
[IsOnlyChild] [nvarchar] (4) COLLATE Chinese_PRC_CI_AS NULL,
[HasPreschool] [nvarchar] (4) COLLATE Chinese_PRC_CI_AS NULL,
[IsLeftBehind] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[NeedSubsidize] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[WayToSchool] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL,
[SchoolRoll] [varchar] (30) COLLATE Chinese_PRC_CI_AS NULL,
[IsMigrantWorkers] [nvarchar] (4) COLLATE Chinese_PRC_CI_AS NULL,
[EntryTime] [datetime] NOT NULL CONSTRAINT [DF_fEdu_Student_EntryTime] DEFAULT (getdate())
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Student] on [dbo].[fEdu_Student]'
GO
ALTER TABLE [dbo].[fEdu_Student] ADD CONSTRAINT [PK_fEdu_Student] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Rebuilding [dbo].[fBox_SMS]'
GO
CREATE TABLE [dbo].[tmp_rg_xx_fBox_SMS]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[NumbersDesc] [varchar] (100) COLLATE Chinese_PRC_CI_AS NOT NULL CONSTRAINT [DF_fBox_SMS_NumbersDesc] DEFAULT (''),
[ToNumbers] [varchar] (max) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Content] [varchar] (1000) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UseMsgCount] [int] NOT NULL,
[ActualSpendMsgCount] [int] NULL,
[Ip] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Referer] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL,
[CreateTime] [datetime] NOT NULL CONSTRAINT [DF_fBox_SMS_CreateTime] DEFAULT (getdate()),
[SubmitTime] [datetime] NULL,
[SendTime] [datetime] NULL,
[Result] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
INSERT INTO [dbo].[tmp_rg_xx_fBox_SMS]([Id], [UserId], [ToNumbers], [Content], [UseMsgCount], [ActualSpendMsgCount], [Ip], [Referer], [CreateTime], [SendTime], [Result]) SELECT [Id], [UserId], [ToNumbers], [Content], [UseMsgCount], [ActualSpendMsgCount], [Ip], [Referer], [RequestTime], [SendTime], [Result] FROM [dbo].[fBox_SMS]
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
DROP TABLE [dbo].[fBox_SMS]
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_rename N'[dbo].[tmp_rg_xx_fBox_SMS]', N'fBox_SMS'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fBox_SMS] on [dbo].[fBox_SMS]'
GO
ALTER TABLE [dbo].[fBox_SMS] ADD CONSTRAINT [PK_fBox_SMS] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Term]'
GO
CREATE TABLE [dbo].[fEdu_Term]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[StartDate] [datetime] NOT NULL,
[Inited] [bit] NOT NULL CONSTRAINT [DF_fEdu_Term_Inited] DEFAULT ((0))
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Term|ظ] on [dbo].[fEdu_Term]'
GO
ALTER TABLE [dbo].[fEdu_Term] ADD CONSTRAINT [PK_fEdu_Term|ظ] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fEdu_Term Name|ѧƲظ] on [dbo].[fEdu_Term]'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_fEdu_Term Name|ѧƲظ] ON [dbo].[fEdu_Term] ([Name])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fEdu_Term StartDate|ѧʱظ] on [dbo].[fEdu_Term]'
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_fEdu_Term StartDate|ѧʱظ] ON [dbo].[fEdu_Term] ([StartDate])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Grade]'
GO
CREATE TABLE [dbo].[fEdu_Grade]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[DepartmentId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Admin] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL,
[Type] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NULL CONSTRAINT [DF_fEdu_Grade_Type] DEFAULT (N''),
[BeginDate] [datetime] NOT NULL,
[IsFinish] [bit] NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Grade] on [dbo].[fEdu_Grade]'
GO
ALTER TABLE [dbo].[fEdu_Grade] ADD CONSTRAINT [PK_fEdu_Grade] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Class]'
GO
CREATE TABLE [dbo].[fEdu_Class]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[GradeId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[OrgId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[DepartmentId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NULL,
[ClassNO] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[HeadTeacher] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Class] on [dbo].[fEdu_Class]'
GO
ALTER TABLE [dbo].[fEdu_Class] ADD CONSTRAINT [PK_fEdu_Class] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_ClassStudent]'
GO
CREATE TABLE [dbo].[fEdu_ClassStudent]
(
[TermId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[ClassId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[StudentId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[NOInClass] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [༶ѧųظ] on [dbo].[fEdu_ClassStudent]'
GO
ALTER TABLE [dbo].[fEdu_ClassStudent] ADD CONSTRAINT [༶ѧųظ] PRIMARY KEY CLUSTERED  ([TermId], [ClassId], [NOInClass])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Exam]'
GO
CREATE TABLE [dbo].[fEdu_Exam]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[TermId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[OrgId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NULL,
[CreateUserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[CreateTime] [datetime] NOT NULL,
[Time] [datetime] NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Exam] on [dbo].[fEdu_Exam]'
GO
ALTER TABLE [dbo].[fEdu_Exam] ADD CONSTRAINT [PK_fEdu_Exam] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fEdu_Exam TermId, CreateTime] on [dbo].[fEdu_Exam]'
GO
CREATE NONCLUSTERED INDEX [IX_fEdu_Exam TermId, CreateTime] ON [dbo].[fEdu_Exam] ([TermId], [CreateTime])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_ExamGrade]'
GO
CREATE TABLE [dbo].[fEdu_ExamGrade]
(
[ExamId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[GradeId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[V] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_ExamGrade] on [dbo].[fEdu_ExamGrade]'
GO
ALTER TABLE [dbo].[fEdu_ExamGrade] ADD CONSTRAINT [PK_fEdu_ExamGrade] PRIMARY KEY CLUSTERED  ([ExamId], [GradeId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_ExamSubject]'
GO
CREATE TABLE [dbo].[fEdu_ExamSubject]
(
[ExamId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[SubjectId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[RateId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_ExamSubject] on [dbo].[fEdu_ExamSubject]'
GO
ALTER TABLE [dbo].[fEdu_ExamSubject] ADD CONSTRAINT [PK_fEdu_ExamSubject] PRIMARY KEY CLUSTERED  ([ExamId], [SubjectId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Subject]'
GO
CREATE TABLE [dbo].[fEdu_Subject]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (20) COLLATE Chinese_PRC_CI_AS NOT NULL,
[DefaultTotalScore] [int] NOT NULL,
[DefaultPassScore] [int] NOT NULL,
[DefaultJoin] [bit] NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Subject] on [dbo].[fEdu_Subject]'
GO
ALTER TABLE [dbo].[fEdu_Subject] ADD CONSTRAINT [PK_fEdu_Subject] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_SubjectRate]'
GO
CREATE TABLE [dbo].[fEdu_SubjectRate]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Total] [int] NOT NULL,
[Pass] [int] NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_SubjectRate] on [dbo].[fEdu_SubjectRate]'
GO
ALTER TABLE [dbo].[fEdu_SubjectRate] ADD CONSTRAINT [PK_fEdu_SubjectRate] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_GradeSubject]'
GO
CREATE TABLE [dbo].[fEdu_GradeSubject]
(
[SubjectId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[GradeId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[V] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_GradeSubject] on [dbo].[fEdu_GradeSubject]'
GO
ALTER TABLE [dbo].[fEdu_GradeSubject] ADD CONSTRAINT [PK_fEdu_GradeSubject] PRIMARY KEY CLUSTERED  ([SubjectId], [GradeId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Parents]'
GO
CREATE TABLE [dbo].[fEdu_Parents]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[OrgId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Sex] [nvarchar] (4) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Phone] [varchar] (30) COLLATE Chinese_PRC_CI_AS NULL,
[Phone2] [varchar] (30) COLLATE Chinese_PRC_CI_AS NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Parents] on [dbo].[fEdu_Parents]'
GO
ALTER TABLE [dbo].[fEdu_Parents] ADD CONSTRAINT [PK_fEdu_Parents] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Results]'
GO
CREATE TABLE [dbo].[fEdu_Results]
(
[ExamId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[SubjectId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[StudentId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Score] [float] NOT NULL,
[EntryTime] [datetime] NOT NULL,
[EntryUserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Results] on [dbo].[fEdu_Results]'
GO
ALTER TABLE [dbo].[fEdu_Results] ADD CONSTRAINT [PK_fEdu_Results] PRIMARY KEY CLUSTERED  ([ExamId], [SubjectId], [StudentId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_StatisticTemp]'
GO
CREATE TABLE [dbo].[fEdu_StatisticTemp]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[RateId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Type] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Template] [varchar] (max) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_StatisticTemp] on [dbo].[fEdu_StatisticTemp]'
GO
ALTER TABLE [dbo].[fEdu_StatisticTemp] ADD CONSTRAINT [PK_fEdu_StatisticTemp] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_StudentParents]'
GO
CREATE TABLE [dbo].[fEdu_StudentParents]
(
[StudentId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[ParentsId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Title] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_StudentParents] on [dbo].[fEdu_StudentParents]'
GO
ALTER TABLE [dbo].[fEdu_StudentParents] ADD CONSTRAINT [PK_fEdu_StudentParents] PRIMARY KEY CLUSTERED  ([StudentId], [ParentsId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_SubjectTeach]'
GO
CREATE TABLE [dbo].[fEdu_SubjectTeach]
(
[TermId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[ClassId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[SubjectId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[TeacherId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_SubjectTeach] on [dbo].[fEdu_SubjectTeach]'
GO
ALTER TABLE [dbo].[fEdu_SubjectTeach] ADD CONSTRAINT [PK_fEdu_SubjectTeach] PRIMARY KEY CLUSTERED  ([TermId], [ClassId], [SubjectId], [TeacherId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_p_iw_AccessSystem]'
GO
CREATE TABLE [dbo].[fBox_p_iw_AccessSystem]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Url] [varchar] (200) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[FullName] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[OrgNO] [varchar] (20) COLLATE Chinese_PRC_CI_AS NOT NULL,
[AccessByOneUser] [bit] NOT NULL,
[CanAccessRoles] [varchar] (1000) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fBox_p_iw_AccessSystem] on [dbo].[fBox_p_iw_AccessSystem]'
GO
ALTER TABLE [dbo].[fBox_p_iw_AccessSystem] ADD CONSTRAINT [PK_fBox_p_iw_AccessSystem] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_p_iw_SystemClient]'
GO
CREATE TABLE [dbo].[fBox_p_iw_SystemClient]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Url] [varchar] (200) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[FullName] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[OrgNO] [varchar] (20) COLLATE Chinese_PRC_CI_AS NOT NULL,
[OrgId] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Key] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[AccessByOneUser] [bit] NOT NULL,
[CanAccessRoles] [varchar] (1000) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fBox_p_iw_SystemClient] on [dbo].[fBox_p_iw_SystemClient]'
GO
ALTER TABLE [dbo].[fBox_p_iw_SystemClient] ADD CONSTRAINT [PK_fBox_p_iw_SystemClient] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_p_iw_SystemClientUser]'
GO
CREATE TABLE [dbo].[fBox_p_iw_SystemClientUser]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[ClientId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[BindUserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fBox_p_iw_SystemClientUser] on [dbo].[fBox_p_iw_SystemClientUser]'
GO
ALTER TABLE [dbo].[fBox_p_iw_SystemClientUser] ADD CONSTRAINT [PK_fBox_p_iw_SystemClientUser] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fEdu_Teacher]'
GO
CREATE TABLE [dbo].[fEdu_Teacher]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fEdu_Teacher] on [dbo].[fEdu_Teacher]'
GO
ALTER TABLE [dbo].[fEdu_Teacher] ADD CONSTRAINT [PK_fEdu_Teacher] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[t_test]'
GO
CREATE TABLE [dbo].[t_test]
(
[id] [int] NULL,
[pid] [int] NULL,
[size] [int] NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fBox_File StoreId, Size] on [dbo].[fBox_File]'
GO
CREATE NONCLUSTERED INDEX [IX_fBox_File StoreId, Size] ON [dbo].[fBox_File] ([StoreId], [Size])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fBox_SpaceFile Id, Type] on [dbo].[fBox_SpaceFile]'
GO
CREATE NONCLUSTERED INDEX [IX_fBox_SpaceFile Id, Type] ON [dbo].[fBox_SpaceFile] ([Id], [Type])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fBox_SpaceFile SpaceID,ParentId,Type] on [dbo].[fBox_SpaceFile]'
GO
CREATE NONCLUSTERED INDEX [IX_fBox_SpaceFile SpaceID,ParentId,Type] ON [dbo].[fBox_SpaceFile] ([SpaceID], [ParentId], [Time], [Type], [State])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding constraints to [dbo].[fEdu_ClassStudent]'
GO
ALTER TABLE [dbo].[fEdu_ClassStudent] ADD CONSTRAINT [һѧÿѧֻһ༶] UNIQUE NONCLUSTERED  ([TermId], [StudentId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_ClassStudent]'
GO
ALTER TABLE [dbo].[fEdu_ClassStudent] ADD CONSTRAINT [FK_fEdu_ClassStudent_fEdu_Class] FOREIGN KEY ([ClassId]) REFERENCES [dbo].[fEdu_Class] ([Id])
ALTER TABLE [dbo].[fEdu_ClassStudent] ADD CONSTRAINT [FK_fEdu_ClassStudent_fEdu_Term] FOREIGN KEY ([TermId]) REFERENCES [dbo].[fEdu_Term] ([Id])
ALTER TABLE [dbo].[fEdu_ClassStudent] ADD CONSTRAINT [FK_fEdu_ClassStudent_fEdu_Student] FOREIGN KEY ([StudentId]) REFERENCES [dbo].[fEdu_Student] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_SubjectTeach]'
GO
ALTER TABLE [dbo].[fEdu_SubjectTeach] ADD CONSTRAINT [FK_fEdu_SubjectTeach_fEdu_Class] FOREIGN KEY ([ClassId]) REFERENCES [dbo].[fEdu_Class] ([Id])
ALTER TABLE [dbo].[fEdu_SubjectTeach] ADD CONSTRAINT [FK_fEdu_SubjectTeach_fEdu_Subject] FOREIGN KEY ([SubjectId]) REFERENCES [dbo].[fEdu_Subject] ([Id])
ALTER TABLE [dbo].[fEdu_SubjectTeach] ADD CONSTRAINT [FK_fEdu_SubjectTeach_fEdu_Term] FOREIGN KEY ([TermId]) REFERENCES [dbo].[fEdu_Term] ([Id])
ALTER TABLE [dbo].[fEdu_SubjectTeach] ADD CONSTRAINT [FK_fEdu_SubjectTeach_fly_User] FOREIGN KEY ([TeacherId]) REFERENCES [dbo].[fly_User] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_Class]'
GO
ALTER TABLE [dbo].[fEdu_Class] ADD CONSTRAINT [FK_fEdu_Class_fEdu_Grade] FOREIGN KEY ([GradeId]) REFERENCES [dbo].[fEdu_Grade] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_ExamGrade]'
GO
ALTER TABLE [dbo].[fEdu_ExamGrade] ADD CONSTRAINT [FK_fEdu_ExamGrade_fEdu_Exam] FOREIGN KEY ([ExamId]) REFERENCES [dbo].[fEdu_Exam] ([Id])
ALTER TABLE [dbo].[fEdu_ExamGrade] ADD CONSTRAINT [FK_fEdu_ExamGrade_fEdu_Grade] FOREIGN KEY ([GradeId]) REFERENCES [dbo].[fEdu_Grade] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_ExamSubject]'
GO
ALTER TABLE [dbo].[fEdu_ExamSubject] ADD CONSTRAINT [FK_fEdu_ExamSubject_fEdu_Exam] FOREIGN KEY ([ExamId]) REFERENCES [dbo].[fEdu_Exam] ([Id])
ALTER TABLE [dbo].[fEdu_ExamSubject] ADD CONSTRAINT [FK_fEdu_ExamSubject_fEdu_Subject] FOREIGN KEY ([SubjectId]) REFERENCES [dbo].[fEdu_Subject] ([Id])
ALTER TABLE [dbo].[fEdu_ExamSubject] ADD CONSTRAINT [FK_fEdu_ExamSubject_fEdu_SubjectRate] FOREIGN KEY ([RateId]) REFERENCES [dbo].[fEdu_SubjectRate] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_Results]'
GO
ALTER TABLE [dbo].[fEdu_Results] ADD CONSTRAINT [FK_fEdu_Results_fEdu_Exam] FOREIGN KEY ([ExamId]) REFERENCES [dbo].[fEdu_Exam] ([Id])
ALTER TABLE [dbo].[fEdu_Results] ADD CONSTRAINT [FK_fEdu_Results_fEdu_Subject] FOREIGN KEY ([SubjectId]) REFERENCES [dbo].[fEdu_Subject] ([Id])
ALTER TABLE [dbo].[fEdu_Results] ADD CONSTRAINT [FK_fEdu_Results_fEdu_Student] FOREIGN KEY ([StudentId]) REFERENCES [dbo].[fEdu_Student] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_Exam]'
GO
ALTER TABLE [dbo].[fEdu_Exam] ADD CONSTRAINT [FK_fEdu_Exam_fly_Org] FOREIGN KEY ([OrgId]) REFERENCES [dbo].[fly_Org] ([Id])
ALTER TABLE [dbo].[fEdu_Exam] ADD CONSTRAINT [FK_fEdu_Exam_fly_User] FOREIGN KEY ([CreateUserId]) REFERENCES [dbo].[fly_User] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_GradeSubject]'
GO
ALTER TABLE [dbo].[fEdu_GradeSubject] ADD CONSTRAINT [FK_fEdu_GradeSubject_fEdu_Grade] FOREIGN KEY ([GradeId]) REFERENCES [dbo].[fEdu_Grade] ([Id])
ALTER TABLE [dbo].[fEdu_GradeSubject] ADD CONSTRAINT [FK_fEdu_GradeSubject_fEdu_Subject] FOREIGN KEY ([SubjectId]) REFERENCES [dbo].[fEdu_Subject] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_StudentParents]'
GO
ALTER TABLE [dbo].[fEdu_StudentParents] ADD CONSTRAINT [FK_fEdu_StudentParents_fEdu_Parents] FOREIGN KEY ([ParentsId]) REFERENCES [dbo].[fEdu_Parents] ([Id])
ALTER TABLE [dbo].[fEdu_StudentParents] ADD CONSTRAINT [FK_fEdu_StudentParents_fEdu_Student] FOREIGN KEY ([StudentId]) REFERENCES [dbo].[fEdu_Student] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_Parents]'
GO
ALTER TABLE [dbo].[fEdu_Parents] ADD CONSTRAINT [FK_fEdu_Parents_fly_Org] FOREIGN KEY ([OrgId]) REFERENCES [dbo].[fly_Org] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_StatisticTemp]'
GO
ALTER TABLE [dbo].[fEdu_StatisticTemp] ADD CONSTRAINT [FK_fEdu_StatisticTemp_fEdu_SubjectRate] FOREIGN KEY ([RateId]) REFERENCES [dbo].[fEdu_SubjectRate] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_Student]'
GO
ALTER TABLE [dbo].[fEdu_Student] ADD CONSTRAINT [FK_fEdu_Student_fly_Org] FOREIGN KEY ([OrgId]) REFERENCES [dbo].[fly_Org] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding foreign keys to [dbo].[fEdu_SubjectRateItem]'
GO
ALTER TABLE [dbo].[fEdu_SubjectRateItem] ADD CONSTRAINT [FK_fEdu_SubjectRateItem_fEdu_SubjectRate] FOREIGN KEY ([RateId]) REFERENCES [dbo].[fEdu_SubjectRate] ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating extended properties'
GO
EXEC sp_addextendedproperty N'MS_Description', N'༶ţ201401', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Class', 'COLUMN', N'ClassNO'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'󶨲', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Class', 'COLUMN', N'DepartmentId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'꼶Id', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Class', 'COLUMN', N'GradeId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Class', 'COLUMN', N'HeadTeacher'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Exam', 'COLUMN', N'Time'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'γ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Grade', 'COLUMN', N'Admin'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ѧ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Grade', 'COLUMN', N'BeginDate'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'󶨲', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Grade', 'COLUMN', N'DepartmentId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ƿѱҵ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Grade', 'COLUMN', N'IsFinish'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'꼶ͣСѧССѧ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Grade', 'COLUMN', N'Type'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Parents', 'COLUMN', N'Name'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ա', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Parents', 'COLUMN', N'Sex'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'û', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Parents', 'COLUMN', N'UserId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ɼ¼ʱ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Results', 'COLUMN', N'EntryTime'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ɼ¼û', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Results', 'COLUMN', N'EntryUserId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'(ũũ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'AccountKind'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'סַ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'Address'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'Birthday'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'BornArea'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'¼ʱ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'EntryTime'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ƿܹѧǰ(ǡ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'HasPreschool'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ַͥ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'HomeAddress'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'Hometown'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'֤', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'IdCard'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ƿضͯ(ضͯضͯ˫ضͯ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'IsLeftBehind'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ǷԱǨŮ(ǡ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'IsMigrantWorkers'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ǷŮ(ǡ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'IsOnlyChild'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ͨŵַ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'MailingAddress'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'Name'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'Nation'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ǷҪ(ǡ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'NeedSubsidize'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ڵ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'OwnerArea'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ϵ绰', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'Phone'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ò(йԱйԤԱԱȺ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'PoliticalAffiliation'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ѧ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'SchoolRoll'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ԱСŮ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'Sex'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'״̬(áһԲȱݡм)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'StateOfHealth'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ͷʽ(߶סУ)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'StudyingWays'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'û', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'UserId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ϸѧʽ(Сǻͨҳн͡У)', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Student', 'COLUMN', N'WayToSchool'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ҳ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_StudentParents', 'COLUMN', N'ParentsId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ѧ', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_StudentParents', 'COLUMN', N'StudentId'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'ν', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_StudentParents', 'COLUMN', N'Title'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
EXEC sp_addextendedproperty N'MS_Description', N'100', 'SCHEMA', N'dbo', 'TABLE', N'fEdu_Subject', 'COLUMN', N'DefaultTotalScore'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
IF EXISTS (SELECT * FROM #tmpErrors) ROLLBACK TRANSACTION
GO


IF @@TRANCOUNT>0 BEGIN
PRINT 'ݿѳɹ 2.2.0'
COMMIT TRANSACTION
END
ELSE PRINT 'ݿʧ'
GO
DROP TABLE #tmpErrors
GO