/*
	Fly.Box-2.1.0  Fly.Box-2.1.2
*/

SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO
BEGIN TRANSACTION
GO
PRINT N'Altering [dbo].[fBox_SpaceFile]'
GO
ALTER TABLE [dbo].[fBox_SpaceFile] ADD
[MaxSize] [bigint] NULL
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_SizeFormat]'
GO



-- =============================================
-- Author:		а
-- Create date: 2014-10-10 
-- Description:	ʽС
-- =============================================
CREATE FUNCTION [dbo].[fBox_SizeFormat]
(
	@size bigint
)
RETURNS VARCHAR(20)
AS
BEGIN
	DECLARE @v VARCHAR(50);

    if (@size >= 1073741824)
        SET @v = CAST( CAST(@size / 1073741824.0 AS NUMERIC(10,1)) AS VARCHAR(10)) + 'G';
    else if (@size >= 1048576)
        SET @v =CAST( CAST(@size / 1048576.0 AS NUMERIC(10,1)) AS VARCHAR(10)) + 'M';
    else
        SET @v =CAST( CAST(@size / 1024.0 AS NUMERIC(10,1)) AS VARCHAR(10)) + 'K';

    SET @v =REPLACE(@v,'.0', '');

    if (@v = '0K' AND @size > 0)
        return '0.1K';
    return @v;
END
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_CheckFolderCanUploadSize]'
GO



-- =============================================
-- Author:		а
-- Create date: 2014-10-10 
-- Description:	֤Ŀ¼ǷϴָСļϼĿ¼֤
-- ֵ 
--	աϴ
--	ϴزϴԭ
-- =============================================
CREATE FUNCTION [dbo].[fBox_CheckFolderCanUploadSize]
(
	@spaceFileId VARCHAR(36),
	@fileSize bigint
)
RETURNS VARCHAR(200)
AS
BEGIN
	DECLARE @departFolderId VARCHAR(36);
	DECLARE @folderName VARCHAR(500);

	SELECT TOP 1 @folderName='ռ䲻㣬ļС'+ Name+''+dbo.fBox_SizeFormat(sf.MaxSize)+'ϴ'+dbo.fBox_SizeFormat(sf.MaxSize-sf.Size)  FROM [dbo].[fBox_GetFileParents](@spaceFileId,0) AS p
	JOIN fBox_SpaceFile sf ON sf.Id=p.Id 
	WHERE sf.MaxSize IS NOT NULL AND (sf.Size+@fileSize>sf.MaxSize)
	RETURN @folderName;	
END
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_SetRoleAclBatch]'
GO





-- =============================================
-- Author:		www.flyui.net
-- Create date: 2014-11-3 
-- Description:	ɫȨ
-- =============================================
CREATE PROCEDURE [dbo].[fBox_SetRoleAclBatch]
	@orgId varchar(36),
	@roleIds varchar(8000),
	@spaceFileId varchar(36),
	@value int
AS
BEGIN
		DELETE fBox_SpaceFileRoleAuth 
			WHERE SpaceFileId=@spaceFileId 
			AND (
					(@roleIds='*' AND RoleID IN(SELECT Id FROM fly_Role WHERE IsPublic=1 OR OrgId=@orgId))
					OR (@roleIds<>'*' AND @roleIds LIKE ('%'+RoleID+'%'))
				);
		
		INSERT fBox_SpaceFileRoleAuth 
			SELECT @spaceFileId as SpaceFileId,Id as RoleId ,@value as ACL FROM fly_Role
			WHERE(
					(@roleIds='*' AND (IsPublic=1 OR OrgId=@orgId))
					OR (@roleIds<>'*' AND @roleIds LIKE ('%'+Id+'%'))
				);

	/*
		UPDATE fBox_SpaceFileRoleAuth 
			SET ACL=CASE @value 
						WHEN 0 THEN ACL | @acl 
						WHEN 1 THEN ACL ^ @acl
					END
		WHERE SpaceFileId=@spaceFileId 
		AND (
				(@roleIds='*' AND RoleID IN(SELECT Id FROM fly_Role WHERE IsPublic=1 OR OrgId=@orgId))
				OR (@roleIds<>'*' AND @roleIds LIKE ('%'+RoleID+'%'))
			);

	*/
END
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_SetUserAclBatch]'
GO






-- =============================================
-- Author:		www.flyui.net
-- Create date: 2014-11-4 
-- Description:	ûȨ
-- =============================================
Create PROCEDURE [dbo].[fBox_SetUserAclBatch]
	@orgId varchar(36),
	@userIds varchar(8000),
	@spaceFileId varchar(36),
	@value int
AS
BEGIN
		DELETE fBox_SpaceFileUserAuth 
			WHERE SpaceFileId=@spaceFileId 
			AND (
					(@userIds='*' AND UserID IN(SELECT Id FROM fly_User WHERE OrgId=@orgId))
					OR (@userIds<>'*' AND @userIds LIKE ('%'+UserID+'%'))
				);
		
		INSERT fBox_SpaceFileUserAuth 
			SELECT @spaceFileId as SpaceFileId,Id as UserId ,@value as ACL FROM fly_User
			WHERE(
					(@userIds='*' AND OrgId=@orgId)
					OR (@userIds<>'*' AND @userIds LIKE ('%'+Id+'%'))
				);
END

GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_SetDepartmentAclBatch]'
GO







-- =============================================
-- Author:		www.flyui.net
-- Create date: 2014-11-4 
-- Description:	ûȨ
-- =============================================
Create PROCEDURE [dbo].[fBox_SetDepartmentAclBatch]
	@orgId varchar(36),
	@departmentIds varchar(8000),
	@spaceFileId varchar(36),
	@value int
AS
BEGIN
		DELETE fBox_SpaceFileDepartmentAuth 
			WHERE SpaceFileId=@spaceFileId 
			AND (
					(@departmentIds='*' AND DepartmentID IN(SELECT Id FROM fly_Department WHERE OrgId=@orgId))
					OR (@departmentIds<>'*' AND @departmentIds LIKE ('%'+DepartmentID+'%'))
				);
		
		INSERT fBox_SpaceFileDepartmentAuth 
			SELECT @spaceFileId as SpaceFileId,Id as DepartmentId ,@value as ACL FROM fly_Department
			WHERE(
					(@departmentIds='*' AND OrgId=@orgId)
					OR (@departmentIds<>'*' AND @departmentIds LIKE ('%'+Id+'%'))
				);
END


GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Altering [dbo].[fBox_GetFileChildren]'
GO

-- =============================================
-- Author:		Kuiyou
-- Create date: 2012-11-9 3:50
-- Description:	ѯ¼Id
-- ѯ p.Level ʾϲļԽϲ㼶Ϊ0
-- =============================================
ALTER FUNCTION [dbo].[fBox_GetFileChildren] 
(
	@spaceFileId varchar(36)
)
RETURNS TABLE 
AS
RETURN 
(
	
	  WITH temp(Id,ParentId,Level) AS(
			SELECT Id,ParentId,Level=0 FROM fBox_SpaceFile WHERE id=@spaceFileId
			UNION ALL
			SELECT p.Id,p.ParentId,Level=t.Level-1 FROM fBox_SpaceFile p JOIN temp t ON p.ParentId=t.Id WHERE p.State<>2
		)
SELECT * FROM temp 
)

GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Altering [dbo].[fBox_IsChildren]'
GO

ALTER FUNCTION [dbo].fBox_IsChildren
(
	@parentId VARCHAR(36),
	@childId VARCHAR(36)
)
RETURNS bit
AS
BEGIN
	IF(EXISTS(SELECT * FROM dbo.fBox_GetFileChildren(@parentId) WHERE [LEVEL]<>0 AND Id=@childId))
		return 1;
	return 0;
END


GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Refreshing [dbo].[fBox_User]'
GO
EXEC sp_refreshview N'[dbo].[fBox_User]'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_Shortcuts]'
GO
CREATE TABLE [dbo].[fBox_Shortcuts]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Location] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Owner] [varchar] (100) COLLATE Chinese_PRC_CI_AS NOT NULL,
[InfoType] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[InfoId] [varchar] (60) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Name] [varchar] (500) COLLATE Chinese_PRC_CI_AS NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fBox_Shortcuts] on [dbo].[fBox_Shortcuts]'
GO
ALTER TABLE [dbo].[fBox_Shortcuts] ADD CONSTRAINT [PK_fBox_Shortcuts] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fBox_Shortcuts Location, Owner] on [dbo].[fBox_Shortcuts]'
GO
CREATE NONCLUSTERED INDEX [IX_fBox_Shortcuts Location, Owner] ON [dbo].[fBox_Shortcuts] ([Location], [Owner])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating index [IX_fBox_Shortcuts InfoType,InfoId] on [dbo].[fBox_Shortcuts]'
GO
CREATE NONCLUSTERED INDEX [IX_fBox_Shortcuts InfoType,InfoId] ON [dbo].[fBox_Shortcuts] ([InfoType], [InfoId])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_SMS]'
GO
CREATE TABLE [dbo].[fBox_SMS]
(
[Id] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UserId] [varchar] (36) COLLATE Chinese_PRC_CI_AS NOT NULL,
[ToNumbers] [varchar] (max) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Content] [varchar] (1000) COLLATE Chinese_PRC_CI_AS NOT NULL,
[UseMsgCount] [int] NOT NULL,
[ActualSpendMsgCount] [int] NULL,
[Ip] [varchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL,
[Referer] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL,
[RequestTime] [datetime] NOT NULL,
[SendTime] [datetime] NULL,
[Result] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL
)
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating primary key [PK_fBox_SMS] on [dbo].[fBox_SMS]'
GO
ALTER TABLE [dbo].[fBox_SMS] ADD CONSTRAINT [PK_fBox_SMS] PRIMARY KEY CLUSTERED  ([Id])
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating [dbo].[fBox_KillLock]'
GO
-- =============================================
-- Author:		Ѱ
-- Create date: 2014-10-11
-- Description:	
-- =============================================
CREATE PROCEDURE dbo.fBox_KillLock
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @spid int;
	DECLARE @sql varchar(100);
	DECLARE @dbid int;
	DECLARE @oldSpid int;

	Select @dbid=dbid From master..sysProcesses Where Spid = @@spid
	--select @dbid

	SET @spid=0;
	WHILE 1=1 BEGIN
		SET @oldSpid = @spid;
		SELECT TOP 1 @spid = spid FROM master..sysprocesses 
			WHERE dbid=@dbid AND blocked>0  AND spid>@spid AND (cpu>1000 OR  login_time<dateadd(s,-20, getdate()) );
		IF(@spid=@oldSpid)
			break

		IF(@spid =0 OR @spid IS NULL) BEGIN
			BREAK
		END ELSE BEGIN
			SET @sql='KILL '+CAST(@spid AS VARCHAR) ;
			print @sql;
			EXEC(@sql)
		END	
	END
END
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding constraints to [dbo].[fBox_SpaceFile]'
GO
ALTER TABLE [dbo].[fBox_SpaceFile] WITH NOCHECK ADD CONSTRAINT [MSG:{ļдСƣĿļмϼļ}] CHECK NOT FOR REPLICATION (([MaxSize] IS NULL OR [Size]<[MaxSize]))
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Adding constraints to [dbo].[fBox_Comment]'
GO
ALTER TABLE [dbo].[fBox_Comment] ADD CONSTRAINT [DF_fBox_Comment_InfoType] DEFAULT ('') FOR [InfoType]
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Altering extended properties'
GO
EXEC sp_updateextendedproperty N'MS_DiagramPane1', N'[0E232FF0-B466-11cf-A24F-00AA00A3EFFF, 1.00]
Begin DesignProperties = 
   Begin PaneConfigurations = 
      Begin PaneConfiguration = 0
         NumPanes = 4
         Configuration = "(H (1[37] 4[23] 2[24] 3) )"
      End
      Begin PaneConfiguration = 1
         NumPanes = 3
         Configuration = "(H (1 [50] 4 [25] 3))"
      End
      Begin PaneConfiguration = 2
         NumPanes = 3
         Configuration = "(H (1 [50] 2 [25] 3))"
      End
      Begin PaneConfiguration = 3
         NumPanes = 3
         Configuration = "(H (4 [30] 2 [40] 3))"
      End
      Begin PaneConfiguration = 4
         NumPanes = 2
         Configuration = "(H (1 [56] 3))"
      End
      Begin PaneConfiguration = 5
         NumPanes = 2
         Configuration = "(H (2 [66] 3))"
      End
      Begin PaneConfiguration = 6
         NumPanes = 2
         Configuration = "(H (4 [50] 3))"
      End
      Begin PaneConfiguration = 7
         NumPanes = 1
         Configuration = "(V (3))"
      End
      Begin PaneConfiguration = 8
         NumPanes = 3
         Configuration = "(H (1[56] 4[18] 2) )"
      End
      Begin PaneConfiguration = 9
         NumPanes = 2
         Configuration = "(H (1 [75] 4))"
      End
      Begin PaneConfiguration = 10
         NumPanes = 2
         Configuration = "(H (1[66] 2) )"
      End
      Begin PaneConfiguration = 11
         NumPanes = 2
         Configuration = "(H (4 [60] 2))"
      End
      Begin PaneConfiguration = 12
         NumPanes = 1
         Configuration = "(H (1) )"
      End
      Begin PaneConfiguration = 13
         NumPanes = 1
         Configuration = "(V (4))"
      End
      Begin PaneConfiguration = 14
         NumPanes = 1
         Configuration = "(V (2))"
      End
      ActivePaneConfig = 0
   End
   Begin DiagramPane = 
      Begin Origin = 
         Top = 0
         Left = 0
      End
      Begin Tables = 
         Begin Table = "u"
            Begin Extent = 
               Top = 6
               Left = 38
               Bottom = 181
               Right = 257
            End
            DisplayFlags = 280
            TopColumn = 7
         End
      End
   End
   Begin SQLPane = 
   End
   Begin DataPane = 
      Begin ParameterDefaults = ""
      End
   End
   Begin CriteriaPane = 
      Begin ColumnWidths = 11
         Column = 1440
         Alias = 900
         Table = 1170
         Output = 720
         Append = 1400
         NewValue = 1170
         SortType = 1350
         SortOrder = 1410
         GroupBy = 1350
         Filter = 1350
         Or = 1350
         Or = 1350
         Or = 1350
      End
   End
End
', 'SCHEMA', N'dbo', 'VIEW', N'fBox_User', NULL, NULL
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
PRINT N'Creating extended properties'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ֵSizeֵܳ', 'SCHEMA', N'dbo', 'TABLE', N'fBox_SpaceFile', 'CONSTRAINT', N'MSG:{ļдСƣĿļмϼļ}'
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO
IF EXISTS (SELECT * FROM #tmpErrors) ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT>0 BEGIN
PRINT 'ݿѳɹ 2.1.2'
COMMIT TRANSACTION
END
ELSE PRINT 'ݿʧ'
GO
DROP TABLE #tmpErrors
GO