/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.util.output;

import com.OooOO0OO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.ClassNameUtils;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.benf.cfr.reader.util.output.StreamDumper;
import org.benf.cfr.reader.util.output.SummaryDumper;

public class FileDumper
extends StreamDumper {
    private final JavaTypeInstance type;
    private final SummaryDumper summaryDumper;
    private final String path;
    private final BufferedWriter writer;
    private static final int MAX_FILE_LEN_MINUS_EXT = 249;
    private static final int TRUNC_PREFIX_LEN = 150;
    private static int truncCount = 0;

    private String mkFilename(String dir, Pair<String, String> names, JavaTypeInstance type, SummaryDumper summaryDumper) {
        String packageName = names.getFirst();
        String className = names.getSecond();
        if (className.length() > 249) {
            className = className.substring(0, 150) + OooOO0OO.OooOOoo0oo("605C594D60") + truncCount++;
            summaryDumper.notify(OooOO0OO.OooOOoo0oo("7C535E4C4C1F515E525A1F") + names.getSecond() + OooOO0OO.OooOOoo0oo("1F485E4C1F4C57504D4B5A515A5B1F4B501F") + className + OooOO0OO.OooOOoo0oo("1F5B4A5A1F4B501F5956535A4C464C4B5A521F535652564B5E4B5650514C11"));
        }
        return dir + File.separator + packageName.replace(OooOO0OO.OooOOoo0oo("11"), File.separator) + (packageName.length() == 0 ? "" : File.separator) + className + OooOO0OO.OooOOoo0oo("11555E495E");
    }

    public FileDumper(String dir, boolean clobber, JavaTypeInstance type, SummaryDumper summaryDumper, TypeUsageInformation typeUsageInformation, Options options, IllegalIdentifierDump illegalIdentifierDump) {
        super(typeUsageInformation, options, illegalIdentifierDump);
        this.type = type;
        this.summaryDumper = summaryDumper;
        Pair<String, String> names = ClassNameUtils.getPackageAndClassNames(type.getRawName());
        try {
            String fileName = this.mkFilename(dir, names, type, summaryDumper);
            File file = new File(fileName);
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IllegalStateException(OooOO0OO.OooOOoo0oo("7C504A535B51184B1F5C4D5A5E4B5A1F5B564D051F") + parent);
            }
            if (file.exists() && !clobber) {
                throw new Dumper.CannotCreate(OooOO0OO.OooOOoo0oo("7956535A1F5E534D5A5E5B461F5A47564C4B4C131F5E515B1F504F4B5650511F18") + OptionsImpl.CLOBBER_FILES.getName() + OooOO0OO.OooOOoo0oo("181F51504B1F4C5A4B"));
            }
            this.path = fileName;
            this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new Dumper.CannotCreate(e);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getFileName() {
        return this.path;
    }

    @Override
    public void addSummaryError(Method method, String s) {
        this.summaryDumper.notifyError(this.type, method, s);
    }
}

